/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.ExtendedNumericComparator;
import org.apache.geode.cache.query.internal.types.MapTypeImpl;
import org.apache.geode.cache.query.internal.types.NumericComparator;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.TemporalComparator;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxInstanceEnum;
import org.apache.geode.pdx.internal.PdxString;

public class TypeUtils
implements OQLLexerTokenTypes {
    protected static List<Class> _numericPrimitiveClasses = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    protected static List<Class> _numericWrapperClasses = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class);
    public static final ObjectType OBJECT_TYPE = new ObjectTypeImpl(Object.class);

    private TypeUtils() {
    }

    public static Comparator getTemporalComparator() {
        return new TemporalComparator();
    }

    public static Comparator getNumericComparator() {
        return new NumericComparator();
    }

    public static Comparator getExtendedNumericComparator() {
        return new ExtendedNumericComparator();
    }

    public static Object checkCast(Object castTarget, Class castClass) {
        if (castTarget == null) {
            return null;
        }
        if (!castClass.isInstance(castTarget)) {
            throw new InternalGemFireError(LocalizedStrings.TypeUtils_EXPECTED_INSTANCE_OF_0_BUT_WAS_1.toLocalizedString(castClass.getName(), castTarget.getClass().getName()));
        }
        return castTarget;
    }

    public static Object indexKeyFor(Object obj) throws TypeMismatchException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                obj = new PdxInstanceEnum((Enum)obj);
            }
            return obj;
        }
        throw new TypeMismatchException(LocalizedStrings.TypeUtils_INDEXES_ARE_NOT_SUPPORTED_FOR_TYPE_0.toLocalizedString(obj.getClass().getName()));
    }

    protected static boolean isAssignableFrom(Class srcType, Class destType) {
        return destType.isAssignableFrom(srcType);
    }

    public static boolean isTypeConvertible(Class srcType, Class destType) {
        if (srcType == null) {
            return TypeUtils.isAssignableFrom(destType, Object.class);
        }
        if (TypeUtils.isAssignableFrom(srcType, destType)) {
            return true;
        }
        if (!(srcType != Boolean.TYPE && srcType != Boolean.class || destType != Boolean.TYPE && destType != Boolean.class)) {
            return true;
        }
        int i = _numericPrimitiveClasses.indexOf(srcType);
        if (i < 0) {
            i = _numericWrapperClasses.indexOf(srcType);
        }
        int destP = _numericPrimitiveClasses.indexOf(destType);
        int destW = -1;
        if (destP < 0) {
            destW = _numericWrapperClasses.indexOf(destType);
        }
        if (i >= 0 && destW == i) {
            return true;
        }
        if (i >= 0 && destP >= i) {
            return true;
        }
        return !(srcType != Character.class && srcType != Character.TYPE || destType != Character.class && destType != Character.TYPE);
    }

    public static boolean areTypesConvertible(Class[] srcTypes, Class[] destTypes) {
        Support.assertArg(srcTypes.length == destTypes.length, "Arguments 'srcTypes' and 'destTypes' must be of same length");
        for (int i = 0; i < srcTypes.length; ++i) {
            if (TypeUtils.isTypeConvertible(srcTypes[i], destTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static ObjectType getObjectType(Class cls) {
        if (cls == Object.class) {
            return OBJECT_TYPE;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return new CollectionTypeImpl(cls, OBJECT_TYPE);
        }
        if (cls.isArray()) {
            return new CollectionTypeImpl(cls, TypeUtils.getObjectType(cls.getComponentType()));
        }
        if (Region.class.isAssignableFrom(cls)) {
            return new CollectionTypeImpl(cls, OBJECT_TYPE);
        }
        if (Map.class.isAssignableFrom(cls)) {
            return new MapTypeImpl(cls, OBJECT_TYPE, OBJECT_TYPE);
        }
        return new ObjectTypeImpl(cls);
    }

    public static ObjectType getRegionEntryType(Region rgn) {
        return new ObjectTypeImpl(Region.Entry.class);
    }

    protected static boolean booleanCompare(Object obj1, Object obj2, int compOp) throws TypeMismatchException {
        if (!(obj1 instanceof Boolean) || !(obj2 instanceof Boolean)) {
            throw new TypeMismatchException(LocalizedStrings.TypeUtils_BOOLEANS_CAN_ONLY_BE_COMPARED_WITH_BOOLEANS.toLocalizedString());
        }
        if (compOp == 13) {
            return obj1.equals(obj2);
        }
        if (compOp == 20) {
            return !obj1.equals(obj2);
        }
        throw new TypeMismatchException(LocalizedStrings.TypeUtils_BOOLEAN_VALUES_CAN_ONLY_BE_COMPARED_WITH_OR.toLocalizedString());
    }

    private static Boolean nullCompare(Object obj1, Object obj2, int compOp) {
        Boolean result = null;
        switch (compOp) {
            case 13: {
                if (obj1 == null) {
                    result = obj2 == null;
                    break;
                }
                result = Boolean.FALSE;
                break;
            }
            case 20: {
                result = obj1 == null ? Boolean.valueOf(obj2 != null) : Boolean.TRUE;
            }
        }
        return result;
    }

    public static Object compare(Object obj1, Object obj2, int compOp) throws TypeMismatchException {
        if (obj1 == null || obj2 == null) {
            Boolean result = TypeUtils.nullCompare(obj1, obj2, compOp);
            if (result == null) {
                return QueryService.UNDEFINED;
            }
            return result;
        }
        if (obj1 == QueryService.UNDEFINED || obj2 == QueryService.UNDEFINED) {
            if (compOp == 20 && (obj1 != QueryService.UNDEFINED || obj2 != QueryService.UNDEFINED)) {
                return true;
            }
            if (compOp == 13 && obj1.equals(obj2)) {
                return true;
            }
            return QueryService.UNDEFINED;
        }
        if (obj1 instanceof EnumInfo.PdxInstanceEnumInfo && obj2 instanceof Enum) {
            obj2 = new PdxInstanceEnum((Enum)obj2);
        } else if (obj1 instanceof Enum && obj2 instanceof EnumInfo.PdxInstanceEnumInfo) {
            obj1 = new PdxInstanceEnum((Enum)obj1);
        }
        if (obj1 instanceof PdxString && obj2 instanceof String) {
            obj2 = new PdxString((String)obj2);
        } else if (obj1 instanceof String && obj2 instanceof PdxString) {
            obj1 = new PdxString((String)obj1);
        }
        try {
            ComparisonStrategy strategy = ComparisonStrategy.get(obj1.getClass(), obj2.getClass(), compOp);
            return strategy.execute(obj1, obj2, compOp);
        }
        catch (ClassCastException | TypeMismatchException e) {
            if (compOp == 13) {
                return Boolean.FALSE;
            }
            if (compOp == 20) {
                return Boolean.TRUE;
            }
            if (TypeUtils.isAssignableFrom(e.getClass(), ClassCastException.class)) {
                throw new TypeMismatchException(LocalizedStrings.TypeUtils_UNABLE_TO_COMPARE_OBJECT_OF_TYPE_0_WITH_OBJECT_OF_TYPE_1.toLocalizedString(obj1.getClass().getName(), obj2.getClass().getName()), e);
            }
            throw e;
        }
    }

    private static enum ComparisonStrategy {
        TEMPORAL{

            @Override
            public Boolean execute(Object object1, Object object2, int comparator) throws ClassCastException {
                return this.applyComparator(TypeUtils.getTemporalComparator().compare(object1, object2), comparator);
            }
        }
        ,
        NUMERIC{

            @Override
            public Boolean execute(Object object1, Object object2, int comparator) throws ClassCastException {
                return this.applyComparator(TypeUtils.getNumericComparator().compare(object1, object2), comparator);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Boolean execute(Object object1, Object object2, int comparator) throws TypeMismatchException {
                return TypeUtils.booleanCompare(object1, object2, comparator);
            }
        }
        ,
        COMPARABLE{

            @Override
            public Boolean execute(Object object1, Object object2, int comparator) throws ClassCastException {
                return this.applyComparator(((Comparable)object1).compareTo(object2), comparator);
            }
        }
        ,
        ARBITRARY{

            @Override
            public Boolean execute(Object object1, Object object2, int comparator) {
                if (comparator == 13) {
                    return object1.equals(object2);
                }
                return !object1.equals(object2);
            }
        };


        protected Boolean applyComparator(int temporalResult, int comparator) throws IllegalArgumentException {
            switch (comparator) {
                case 13: {
                    return temporalResult == 0;
                }
                case 22: {
                    return temporalResult < 0;
                }
                case 18: {
                    return temporalResult <= 0;
                }
                case 23: {
                    return temporalResult > 0;
                }
                case 19: {
                    return temporalResult >= 0;
                }
                case 20: {
                    return temporalResult != 0;
                }
            }
            throw new IllegalArgumentException(LocalizedStrings.TypeUtils_UNKNOWN_OPERATOR_0.toLocalizedString(comparator));
        }

        public static ComparisonStrategy get(Class object1Class, Class object2Class, int comparator) throws TypeMismatchException {
            if (TypeUtils.isAssignableFrom(object1Class, Date.class) && TypeUtils.isAssignableFrom(object1Class, Date.class)) {
                return TEMPORAL;
            }
            if (object1Class != object2Class && TypeUtils.isAssignableFrom(object1Class, Number.class) && TypeUtils.isAssignableFrom(object2Class, Number.class)) {
                return NUMERIC;
            }
            if (TypeUtils.isAssignableFrom(object1Class, Boolean.class) || TypeUtils.isAssignableFrom(object2Class, Boolean.class)) {
                return BOOLEAN;
            }
            if (TypeUtils.isAssignableFrom(object1Class, Comparable.class) && TypeUtils.isAssignableFrom(object2Class, Comparable.class)) {
                return COMPARABLE;
            }
            if (comparator == 13 || comparator == 20) {
                return ARBITRARY;
            }
            throw new TypeMismatchException(LocalizedStrings.TypeUtils_UNABLE_TO_USE_A_RELATIONAL_COMPARISON_OPERATOR_TO_COMPARE_AN_INSTANCE_OF_CLASS_0_WITH_AN_INSTANCE_OF_1.toLocalizedString(object1Class.getName(), object2Class.getName()));
        }

        public abstract Boolean execute(Object var1, Object var2, int var3) throws TypeMismatchException, ClassCastException;
    }
}

