/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReliableReplyException;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ReliableReplyProcessor21
extends ReplyProcessor21 {
    private Set departedMembers;

    public ReliableReplyProcessor21(InternalDistributedSystem system, InternalDistributedMember member) {
        super(system, member);
    }

    public ReliableReplyProcessor21(DistributionManager dm, InternalDistributedMember member) {
        super(dm, member);
    }

    public ReliableReplyProcessor21(DistributionManager dm, Collection initMembers) {
        super(dm, initMembers);
    }

    public ReliableReplyProcessor21(InternalDistributedSystem system, Collection initMembers) {
        super(system, initMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (this.removeMember(id, true)) {
            ReliableReplyProcessor21 reliableReplyProcessor21 = this;
            synchronized (reliableReplyProcessor21) {
                if (this.departedMembers == null) {
                    this.departedMembers = new HashSet();
                }
                this.departedMembers.add(id);
            }
        }
        this.checkIfDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDepartedMembers() {
        ReliableReplyProcessor21 reliableReplyProcessor21 = this;
        synchronized (reliableReplyProcessor21) {
            if (this.departedMembers == null) {
                return Collections.EMPTY_SET;
            }
            return this.departedMembers;
        }
    }

    public void waitForReliableDelivery() throws ReplyException, InterruptedException, ReliableReplyException {
        this.waitForReliableDelivery(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReliableDelivery(long msecs) throws ReplyException, InterruptedException, ReliableReplyException {
        super.waitForReplies(msecs);
        ReliableReplyProcessor21 reliableReplyProcessor21 = this;
        synchronized (reliableReplyProcessor21) {
            if (this.departedMembers != null) {
                throw new ReliableReplyException(LocalizedStrings.ReliableReplyProcessor_FAILED_TO_DELIVER_MESSAGE_TO_MEMBERS_0.toLocalizedString(this.departedMembers));
            }
        }
    }
}

