/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ReplyMessage
extends HighPriorityDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    protected int processorId;
    protected boolean ignored = false;
    protected boolean closed = false;
    private boolean returnValueIsException;
    private Object returnValue;
    private transient boolean sendViaJGroups;
    protected transient boolean internal;
    public static final byte PROCESSOR_ID_FLAG = 1;
    public static final byte IGNORED_FLAG = 2;
    public static final byte EXCEPTION_FLAG = 4;
    public static final byte CLOSED_FLAG = 8;
    public static final byte HAS_TX_CHANGES = 16;
    public static final byte TIME_STATS_SET = 32;
    public static final byte OBJECT_FLAG = 64;
    public static final byte INTERNAL_FLAG = -128;

    public void setProcessorId(int id) {
        this.processorId = id;
    }

    @Override
    public boolean sendViaUDP() {
        return this.sendViaJGroups;
    }

    public void setException(ReplyException ex) {
        this.returnValue = ex;
        this.returnValueIsException = true;
    }

    public void setReturnValue(Object o) {
        this.returnValue = o;
        this.returnValueIsException = false;
    }

    @Override
    public boolean getInlineProcess() {
        return this.getClass().equals(ReplyMessage.class);
    }

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ReplySender dm) {
        ReplyMessage.send(recipient, processorId, exception, dm, false);
    }

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ReplySender dm, boolean internal) {
        Assert.assertTrue(recipient != null, "Sending a ReplyMessage to ALL");
        ReplyMessage m = new ReplyMessage();
        m.processorId = processorId;
        if (exception != null) {
            m.returnValue = exception;
            m.returnValueIsException = true;
        }
        if (exception != null && logger.isDebugEnabled()) {
            if (exception.getCause() != null && exception.getCause() instanceof EntryNotFoundException) {
                logger.debug("Replying with entry-not-found: {}", (Object)exception.getCause().getMessage());
            } else if (exception.getCause() != null && exception.getCause() instanceof ConcurrentCacheModificationException) {
                logger.debug("Replying with concurrent-modification-exception");
            } else {
                logger.debug("Replying with exception: " + m, (Throwable)exception);
            }
        }
        m.setRecipient(recipient);
        dm.putOutgoing(m);
    }

    public static void send(InternalDistributedMember recipient, int processorId, Object returnValue, ReplySender dm) {
        Assert.assertTrue(recipient != null, "Sending a ReplyMessage to ALL");
        ReplyMessage m = new ReplyMessage();
        m.processorId = processorId;
        if (returnValue != null) {
            m.returnValue = returnValue;
            m.returnValueIsException = false;
        }
        m.setRecipient(recipient);
        dm.putOutgoing(m);
    }

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ReplySender dm, boolean ignored, boolean closed, boolean sendViaJGroups) {
        ReplyMessage.send(recipient, processorId, exception, dm, ignored, false, false, false);
    }

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ReplySender dm, boolean ignored, boolean closed, boolean sendViaJGroups, boolean internal) {
        Assert.assertTrue(recipient != null, "Sending a ReplyMessage to ALL");
        ReplyMessage m = new ReplyMessage();
        m.processorId = processorId;
        m.ignored = ignored;
        if (exception != null) {
            m.returnValue = exception;
            m.returnValueIsException = true;
        }
        m.closed = closed;
        m.sendViaJGroups = sendViaJGroups;
        if (logger.isDebugEnabled()) {
            if (exception != null && ignored) {
                if (exception.getCause() instanceof InvalidDeltaException) {
                    logger.debug("Replying with invalid-delta: {}", (Object)exception.getCause().getMessage());
                } else {
                    logger.debug("Replying with ignored=true and exception: {}", (Object)m, (Object)exception);
                }
            } else if (exception != null) {
                if (exception.getCause() != null && exception.getCause() instanceof EntryNotFoundException) {
                    logger.debug("Replying with entry-not-found: {}", (Object)exception.getCause().getMessage());
                } else if (exception.getCause() != null && exception.getCause() instanceof ConcurrentCacheModificationException) {
                    logger.debug("Replying with concurrent-modification-exception");
                } else {
                    logger.debug("Replying with exception: {}", (Object)m, (Object)exception);
                }
            } else if (ignored) {
                logger.debug("Replying with ignored=true: {}", (Object)m);
            }
        }
        m.setRecipient(recipient);
        dm.putOutgoing(m);
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        this.dmProcess(dm);
    }

    public void dmProcess(DistributionManager dm) {
        long startTime = this.getTimestamp();
        ReplyProcessor21 processor = ReplyProcessor21.getProcessor(this.processorId);
        try {
            this.process(dm, processor);
            if (DistributionStats.enableClockStats) {
                dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
            }
        }
        catch (RuntimeException ex) {
            if (processor != null) {
                processor.cancel(this.getSender(), ex);
            }
            throw ex;
        }
    }

    public void process(DistributionManager dm, ReplyProcessor21 processor) {
        if (processor == null) {
            return;
        }
        processor.process(this);
    }

    public Object getReturnValue() {
        if (this.returnValueIsException) {
            return null;
        }
        return this.returnValue;
    }

    public ReplyException getException() {
        if (this.returnValueIsException) {
            InternalDistributedMember sendr;
            ReplyException exception = (ReplyException)this.returnValue;
            if (exception != null && (sendr = this.getSender()) != null) {
                exception.setSenderIfNull(sendr);
            }
            return exception;
        }
        return null;
    }

    public boolean getIgnored() {
        return this.ignored;
    }

    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public int getDSFID() {
        return 72;
    }

    private static boolean testFlag(byte status, byte flag) {
        return (status & flag) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        int status = 0;
        if (this.ignored) {
            status = (byte)(status | 2);
        }
        if (this.returnValueIsException) {
            status = (byte)(status | 4);
        } else if (this.returnValue != null) {
            status = (byte)(status | 0x40);
        }
        if (this.processorId != 0) {
            status = (byte)(status | 1);
        }
        if (this.closed) {
            status = (byte)(status | 8);
        }
        if (this.internal) {
            status = (byte)(status | 0xFFFFFF80);
        }
        out.writeByte(status);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.returnValueIsException || this.returnValue != null) {
            DataSerializer.writeObject(this.returnValue, out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        byte status = in.readByte();
        this.ignored = ReplyMessage.testFlag(status, (byte)2);
        this.closed = ReplyMessage.testFlag(status, (byte)8);
        if (ReplyMessage.testFlag(status, (byte)1)) {
            this.processorId = in.readInt();
        }
        if (ReplyMessage.testFlag(status, (byte)4)) {
            this.returnValue = DataSerializer.readObject(in);
            this.returnValueIsException = true;
        } else if (ReplyMessage.testFlag(status, (byte)64)) {
            this.returnValue = DataSerializer.readObject(in);
        }
        this.internal = ReplyMessage.testFlag(status, (byte)-128);
    }

    protected StringBuilder getStringBuilder() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortClassName());
        sb.append(" processorId=");
        sb.append(this.processorId);
        sb.append(" from ");
        sb.append(this.getSender());
        ReplyException ex = this.getException();
        if (ex != null) {
            if (ex.getCause() != null && ex.getCause() instanceof InvalidDeltaException) {
                sb.append(" with request for full value");
            } else {
                sb.append(" with exception ");
                sb.append(ex);
            }
        }
        return sb;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String toString() {
        return this.getStringBuilder().toString();
    }
}

