/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.internal.Version;

public class JoinResponseMessage
extends HighPriorityDistributionMessage {
    private NetView currentView;
    private String rejectionMessage;
    private InternalDistributedMember memberID;
    private byte[] messengerData;
    private int requestId;
    private byte[] secretPk;

    public JoinResponseMessage(InternalDistributedMember memberID, NetView view, int requestId) {
        this.currentView = view;
        this.memberID = memberID;
        this.requestId = requestId;
        this.setRecipient(memberID);
    }

    public JoinResponseMessage(InternalDistributedMember memberID, byte[] sPk, int requestId) {
        this.memberID = memberID;
        this.requestId = requestId;
        this.secretPk = sPk;
        this.setRecipient(memberID);
    }

    public JoinResponseMessage(String rejectionMessage, int requestId) {
        this.rejectionMessage = rejectionMessage;
        this.requestId = requestId;
    }

    public JoinResponseMessage() {
    }

    public byte[] getSecretPk() {
        return this.secretPk;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public NetView getCurrentView() {
        return this.currentView;
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public byte[] getMessengerData() {
        return this.messengerData;
    }

    public void setMessengerData(byte[] data) {
        this.messengerData = data;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        throw new IllegalStateException("JoinResponse is not intended to be executed");
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; " + (this.currentView == null ? "" : this.currentView.toString()) + (this.rejectionMessage == null ? "" : "; " + this.rejectionMessage) + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -143;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.currentView, out);
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.rejectionMessage, out);
        DataSerializer.writeByteArray(this.messengerData, out);
        DataSerializer.writeByteArray(this.secretPk, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.currentView = (NetView)DataSerializer.readObject(in);
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.rejectionMessage = DataSerializer.readString(in);
        this.messengerData = DataSerializer.readByteArray(in);
        this.secretPk = DataSerializer.readByteArray(in);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinResponseMessage other = (JoinResponseMessage)obj;
        if (this.currentView == null ? other.currentView != null : !this.currentView.equals(other.currentView)) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        if (!Arrays.equals(this.messengerData, other.messengerData)) {
            return false;
        }
        if (this.rejectionMessage == null ? other.rejectionMessage != null : !this.rejectionMessage.equals(other.rejectionMessage)) {
            return false;
        }
        return Arrays.equals(this.secretPk, other.secretPk);
    }
}

