/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectRequest;
import org.apache.geode.internal.Version;

public class SuspectMembersMessage
extends HighPriorityDistributionMessage {
    final List<SuspectRequest> suspectRequests;

    public SuspectMembersMessage(List<InternalDistributedMember> recipients, List<SuspectRequest> s) {
        this.setRecipients(recipients);
        this.suspectRequests = s;
    }

    public SuspectMembersMessage() {
        this.suspectRequests = new ArrayList<SuspectRequest>();
    }

    @Override
    public int getDSFID() {
        return -156;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    public List<SuspectRequest> getMembers() {
        return this.suspectRequests;
    }

    @Override
    public String toString() {
        return "SuspectMembersMessage [suspectRequests=" + this.suspectRequests + "]";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.suspectRequests != null) {
            out.writeInt(this.suspectRequests.size());
            for (SuspectRequest sr : this.suspectRequests) {
                DataSerializer.writeObject(sr.getSuspectMember(), out);
                DataSerializer.writeString(sr.getReason(), out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SuspectRequest sr = new SuspectRequest((InternalDistributedMember)DataSerializer.readObject(in), DataSerializer.readString(in));
            this.suspectRequests.add(sr);
        }
    }
}

