/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.InternalDistributedRegion;
import org.apache.geode.internal.cache.LatestLastAccessTimeReplyProcessor;
import org.apache.geode.internal.cache.RegionEntry;

public class LatestLastAccessTimeMessage<K>
extends PooledDistributionMessage
implements MessageWithReply {
    private int processorId;
    private String regionName;
    private K key;

    public LatestLastAccessTimeMessage() {
    }

    public LatestLastAccessTimeMessage(LatestLastAccessTimeReplyProcessor replyProcessor, Set<InternalDistributedMember> recipients, InternalDistributedRegion region, K key) {
        this.setRecipients(recipients);
        this.processorId = replyProcessor.getProcessorId();
        this.key = key;
        this.regionName = region.getFullPath();
    }

    @Override
    public int getDSFID() {
        return -20;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        RegionEntry entry;
        long latestLastAccessTime = 0L;
        InternalDistributedRegion region = (InternalDistributedRegion)dm.getCache().getRegion(this.regionName);
        if (region != null && (entry = region.getRegionEntry(this.key)) != null) {
            try {
                latestLastAccessTime = entry.getLastAccessed();
            }
            catch (InternalStatisticsDisabledException internalStatisticsDisabledException) {
                // empty catch block
            }
        }
        ReplyMessage.send(this.getSender(), this.processorId, latestLastAccessTime, (ReplySender)dm);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = DataSerializer.readPrimitiveInt(in);
        this.regionName = DataSerializer.readString(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writePrimitiveInt(this.processorId, out);
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeObject(this.key, out);
    }
}

