/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.NWayMergeResults;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PartitionedRegionQueryEvaluator;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PRQueryProcessor {
    private static final Logger logger = LogService.getLogger();
    static final int BUCKET_QUERY_TIMEOUT = 60;
    public static final int NUM_THREADS = Integer.getInteger("gemfire.PRQueryProcessor.numThreads", 1);
    public static int TEST_NUM_THREADS = 0;
    private PartitionedRegionDataStore _prds;
    private PartitionedRegion pr;
    private final DefaultQuery query;
    private final Object[] parameters;
    private final List<Integer> _bucketsToQuery;
    private volatile int numBucketsProcessed = 0;
    private volatile ObjectType resultType = null;
    private boolean isIndexUsedForLocalQuery = false;

    public PRQueryProcessor(PartitionedRegionDataStore prDS, DefaultQuery query, Object[] parameters, List<Integer> buckets) {
        Assert.assertTrue(!buckets.isEmpty(), "bucket list can not be empty. ");
        this._prds = prDS;
        this._bucketsToQuery = buckets;
        prDS.partitionedRegion.getCache().getLocalQueryService();
        this.query = query;
        this.parameters = parameters;
        PRQueryExecutor.initializeExecutorService();
    }

    public PRQueryProcessor(PartitionedRegion pr, DefaultQuery query, Object[] parameters, List buckets) {
        Assert.assertTrue(!buckets.isEmpty(), "bucket list can not be empty. ");
        this.pr = pr;
        this._bucketsToQuery = buckets;
        this.query = query;
        this.parameters = parameters;
        PRQueryExecutor.initializeExecutorService();
    }

    private synchronized void incNumBucketsProcessed() {
        ++this.numBucketsProcessed;
    }

    private synchronized int getNumBucketsProcessed() {
        return this.numBucketsProcessed;
    }

    public boolean executeQuery(Collection<Collection> resultCollector) throws QueryException, InterruptedException, ForceReattemptException {
        if (NUM_THREADS > 1 || TEST_NUM_THREADS > 1) {
            this.executeWithThreadPool(resultCollector);
        } else {
            this.executeSequentially(resultCollector, this._bucketsToQuery);
        }
        return this.resultType.isStructType();
    }

    private void executeWithThreadPool(Collection<Collection> resultCollector) throws QueryException, InterruptedException, ForceReattemptException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        List callableTasks = this.buildCallableTaskList(resultCollector);
        ExecutorService execService = PRQueryExecutor.getExecutorService();
        boolean reattemptNeeded = false;
        Object fre = null;
        if (callableTasks != null && !callableTasks.isEmpty()) {
            List futures = null;
            futures = execService.invokeAll(callableTasks, 300L, TimeUnit.SECONDS);
            if (futures != null) {
                Iterator itr = futures.iterator();
                while (itr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = itr.next();
                    QueryTask.BucketQueryResult bqr = null;
                    try {
                        bqr = (QueryTask.BucketQueryResult)fut.get(60L, TimeUnit.SECONDS);
                        bqr.handleAndThrowException();
                        if (!bqr.retry) continue;
                        reattemptNeeded = true;
                    }
                    catch (TimeoutException e) {
                        throw new InternalGemFireException(LocalizedStrings.PRQueryProcessor_TIMED_OUT_WHILE_EXECUTING_QUERY_TIME_EXCEEDED_0.toLocalizedString(60), e);
                    }
                    catch (ExecutionException ee) {
                        Throwable cause = ee.getCause();
                        if (cause instanceof QueryException) {
                            throw (QueryException)cause;
                        }
                        throw new InternalGemFireException(LocalizedStrings.PRQueryProcessor_GOT_UNEXPECTED_EXCEPTION_WHILE_EXECUTING_QUERY_ON_PARTITIONED_REGION_BUCKET.toLocalizedString(), cause);
                    }
                }
                CompiledSelect cs = this.query.getSimpleSelect();
                if (cs != null && (cs.isOrderBy() || cs.isGroupBy())) {
                    QueryExecutionContext context = new QueryExecutionContext(this.parameters, this.pr.getCache());
                    int limit = this.query.getLimit(this.parameters);
                    Collection mergedResults = this.coalesceOrderedResults(resultCollector, context, cs, limit);
                    resultCollector.clear();
                    resultCollector.add(mergedResults);
                }
            }
        }
        if (execService == null || execService.isShutdown() || execService.isTerminated()) {
            this._prds.partitionedRegion.checkReadiness();
        }
        if (reattemptNeeded) {
            throw fre;
        }
    }

    private void doBucketQuery(Integer bId, PartitionedRegionDataStore prds, DefaultQuery query, Object[] params, PartitionedRegionQueryEvaluator.PRQueryResultCollector rq) throws QueryException, ForceReattemptException, InterruptedException {
        BucketRegion bukRegion = (BucketRegion)prds.getLocalBucket2RegionMap().get(bId);
        PartitionedRegion pr = prds.getPartitionedRegion();
        try {
            pr.checkReadiness();
            if (bukRegion == null) {
                if (pr.isLocallyDestroyed || pr.isClosed) {
                    throw new RegionDestroyedException("PR destroyed during query", pr.getFullPath());
                }
                throw new ForceReattemptException("Bucket id " + pr.bucketStringForLogs(bId) + " not found on VM " + pr.getMyId());
            }
            bukRegion.waitForData();
            SelectResults results = null;
            int limit = -1;
            if (query.getSimpleSelect().getOrderByAttrs() == null) {
                limit = query.getLimit(params);
            }
            if (!bukRegion.isBucketDestroyed()) {
                int numBucketsProcessed = this.getNumBucketsProcessed();
                if (limit < 0 || rq.size() - numBucketsProcessed < limit) {
                    results = (SelectResults)query.prExecuteOnBucket(params, pr, bukRegion);
                    this.resultType = results.getCollectionType().getElementType();
                }
                if (!bukRegion.isBucketDestroyed()) {
                    if (results != null) {
                        for (Object r : results) {
                            if (r == null) {
                                rq.put(DefaultQuery.NULL_RESULT);
                            } else if (!query.getSimpleSelect().isDistinct() && query.getSimpleSelect().isCount() && r instanceof Integer) {
                                if ((Integer)r != 0) {
                                    rq.put(r);
                                }
                            } else {
                                rq.put(r);
                            }
                            if (limit < 0 || rq.size() - numBucketsProcessed < limit) continue;
                            break;
                        }
                    }
                    rq.put(new EndOfBucket(bId));
                    this.incNumBucketsProcessed();
                    return;
                }
            }
            PRQueryProcessor.checkForBucketMoved(bId, bukRegion, pr);
            Assert.assertTrue(false, "checkForBucketMoved should have thrown ForceReattemptException");
        }
        catch (RegionDestroyedException rde) {
            PRQueryProcessor.checkForBucketMoved(bId, bukRegion, pr);
            throw rde;
        }
        catch (QueryException qe) {
            PRQueryProcessor.checkForBucketMoved(bId, bukRegion, pr);
            throw qe;
        }
    }

    private static void checkForBucketMoved(Integer bId, BucketRegion br, PartitionedRegion pr) throws ForceReattemptException, RegionDestroyedException {
        if (br.isBucketDestroyed()) {
            if (pr.isLocallyDestroyed || pr.isClosed) {
                throw new RegionDestroyedException("PR destroyed during query", pr.getFullPath());
            }
            pr.checkReadiness();
            throw new ForceReattemptException("Bucket id " + pr.bucketStringForLogs(bId) + " not found on VM " + pr.getMyId());
        }
    }

    private void executeSequentially(Collection<Collection> resultCollector, List buckets) throws QueryException, InterruptedException, ForceReattemptException {
        QueryExecutionContext context = new QueryExecutionContext(this.parameters, this.pr.getCache(), this.query);
        CompiledSelect cs = this.query.getSimpleSelect();
        int limit = this.query.getLimit(this.parameters);
        if (cs != null && cs.isOrderBy()) {
            for (Integer bucketID : this._bucketsToQuery) {
                List<Integer> singleBucket = Collections.singletonList(bucketID);
                ((ExecutionContext)context).setBucketList(singleBucket);
                this.executeQueryOnBuckets(resultCollector, context);
            }
            Collection mergedResults = this.coalesceOrderedResults(resultCollector, context, cs, limit);
            resultCollector.clear();
            resultCollector.add(mergedResults);
        } else {
            ((ExecutionContext)context).setBucketList(buckets);
            this.executeQueryOnBuckets(resultCollector, context);
        }
    }

    private Collection coalesceOrderedResults(Collection<Collection> results, ExecutionContext context, CompiledSelect cs, int limit) {
        ArrayList<Collection> sortedResults = new ArrayList<Collection>(results.size());
        for (Collection o : results) {
            if (!(o instanceof Collection)) continue;
            sortedResults.add(o);
        }
        return new NWayMergeResults(sortedResults, cs.isDistinct(), limit, cs.getOrderByAttrs(), context, cs.getElementTypeForOrderByQueries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryOnBuckets(Collection<Collection> resultCollector, ExecutionContext context) throws ForceReattemptException, QueryInvocationTargetException, QueryException {
        QueryMonitor queryMonitor = null;
        context.setCqQueryContext(this.query.isCqQuery());
        if (GemFireCacheImpl.getInstance() != null) {
            queryMonitor = GemFireCacheImpl.getInstance().getQueryMonitor();
        }
        try {
            if (queryMonitor != null) {
                queryMonitor.monitorQueryThread(Thread.currentThread(), this.query);
            }
            Object results = this.query.executeUsingContext(context);
            Collection<Collection> collection = resultCollector;
            synchronized (collection) {
                this.resultType = ((SelectResults)results).getCollectionType().getElementType();
                resultCollector.add((Collection)results);
            }
            this.isIndexUsedForLocalQuery = ((QueryExecutionContext)context).isIndexUsed();
        }
        catch (BucketMovedException bme) {
            if (logger.isDebugEnabled()) {
                logger.debug("Query targeted local bucket not found. {}", (Object)bme.getMessage(), (Object)bme);
            }
            throw new ForceReattemptException("Query targeted local bucket not found." + bme.getMessage(), bme);
        }
        catch (RegionDestroyedException rde) {
            throw new QueryInvocationTargetException("The Region on which query is executed may have been destroyed." + rde.getMessage(), rde);
        }
        catch (QueryException qe) {
            if (this.pr.isLocallyDestroyed || this.pr.isClosed) {
                throw new ForceReattemptException("Local Partition Region or the targeted bucket has been moved");
            }
            throw qe;
        }
        finally {
            if (queryMonitor != null) {
                queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this.query);
            }
        }
    }

    private List buildCallableTaskList(Collection<Collection> resultsColl) {
        ArrayList<QueryTask> callableTasks = new ArrayList<QueryTask>();
        for (Integer bId : this._bucketsToQuery) {
            callableTasks.add(new QueryTask(this.query, this.parameters, this._prds, bId, resultsColl));
        }
        return callableTasks;
    }

    public boolean isIndexUsed() {
        return this.isIndexUsedForLocalQuery;
    }

    public static void shutdown() {
        PRQueryExecutor.shutdown();
    }

    public static void shutdownNow() {
        PRQueryExecutor.shutdownNow();
    }

    private class QueryTask
    implements Callable {
        private final DefaultQuery query;
        private final Object[] parameters;
        private final PartitionedRegionDataStore _prDs;
        private final Integer _bucketId;
        private final Collection<Collection> resultColl;

        public QueryTask(DefaultQuery query, Object[] parameters, PartitionedRegionDataStore prDS, Integer bucketId, Collection<Collection> rColl) {
            this.query = query;
            this._prDs = prDS;
            this._bucketId = bucketId;
            this.resultColl = rColl;
            this.parameters = parameters;
        }

        public Object call() throws Exception {
            BucketQueryResult bukResult = new BucketQueryResult(this._bucketId);
            boolean retry = false;
            try {
                QueryObserver observer = QueryObserverHolder.getInstance();
                if (observer == null || observer instanceof IndexTrackingQueryObserver) {
                    // empty if block
                }
                List<Integer> bucketList = Collections.singletonList(this._bucketId);
                QueryExecutionContext context = new QueryExecutionContext(this.parameters, PRQueryProcessor.this.pr.getCache(), this.query);
                ((ExecutionContext)context).setBucketList(bucketList);
                PRQueryProcessor.this.executeQueryOnBuckets(this.resultColl, context);
            }
            catch (ForceReattemptException fre) {
                bukResult.setException(fre);
            }
            catch (QueryException e) {
                bukResult.setException(e);
            }
            catch (CacheRuntimeException cre) {
                bukResult.setException(cre);
            }
            return bukResult;
        }

        private class BucketQueryResult {
            private int _buk;
            private Exception _ex = null;
            public boolean retry = false;

            public BucketQueryResult(int bukId) {
                this._buk = bukId;
            }

            public Exception getException() {
                return this._ex;
            }

            public boolean exceptionOccurred() {
                return this._ex != null;
            }

            public void setException(Exception e) {
                this._ex = e;
            }

            public Integer getBucketId() {
                return this._buk;
            }

            public boolean isReattemptNeeded() {
                return this._ex instanceof ForceReattemptException;
            }

            public void handleAndThrowException() throws QueryException {
                if (this._ex != null) {
                    if (this._ex instanceof QueryException) {
                        throw (QueryException)this._ex;
                    }
                    if (this._ex instanceof CacheRuntimeException) {
                        throw (CacheRuntimeException)this._ex;
                    }
                }
            }
        }
    }

    public static class EndOfBucket
    implements DataSerializableFixedID {
        private int bucketId;

        public EndOfBucket() {
        }

        public EndOfBucket(int bucketId) {
            this.bucketId = bucketId;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public String toString() {
            return "EndOfBucket(" + this.bucketId + ")";
        }

        @Override
        public int getDSFID() {
            return 14;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.bucketId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.bucketId);
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    static class PRQueryExecutor {
        private static ExecutorService execService = null;

        PRQueryExecutor() {
        }

        static synchronized void shutdown() {
            if (execService != null) {
                execService.shutdown();
            }
        }

        static synchronized void shutdownNow() {
            if (execService != null) {
                execService.shutdownNow();
            }
        }

        static synchronized ExecutorService getExecutorService() {
            if (execService == null) {
                PRQueryExecutor.initializeExecutorService();
            }
            assert (execService != null);
            return execService;
        }

        static synchronized void initializeExecutorService() {
            if (execService == null || execService.isShutdown() || execService.isTerminated()) {
                int numThreads = TEST_NUM_THREADS > 1 ? TEST_NUM_THREADS : NUM_THREADS;
                execService = Executors.newFixedThreadPool(numThreads);
            }
        }
    }
}

