/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.RegionMapOwner;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PlaceHolderDiskRegion
extends AbstractDiskRegion
implements DiskRecoveryStore,
RegionMapOwner {
    private final String name;

    PlaceHolderDiskRegion(DiskStoreImpl ds, long id, String name) {
        super(ds, id);
        this.name = name;
    }

    PlaceHolderDiskRegion(DiskRegionView drv) {
        super(drv);
        this.name = drv.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrName() {
        assert (this.isBucket());
        String bn = PartitionedRegionHelper.getBucketName(this.name);
        return PartitionedRegionHelper.getPRPath(bn);
    }

    @Override
    void beginDestroyRegion(LocalRegion region) {
    }

    @Override
    public void finishPendingDestroy() {
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name=").append(this.name).append(" id=").append(this.getId());
        return sb.toString();
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this;
    }

    @Override
    public DiskEntry getDiskEntry(Object key) {
        RegionEntry re = this.getRecoveredEntryMap().getEntry(key);
        if (re != null && re.isRemoved() && !re.isTombstone()) {
            re = null;
        }
        return (DiskEntry)re;
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        RegionEntry re = this.getRecoveredEntryMap().initRecoveredEntry(key, value);
        if (re == null) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_ENTRY_ALREADY_EXISTED_0.toLocalizedString(key));
        }
        return (DiskEntry)re;
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        return (DiskEntry)this.getRecoveredEntryMap().updateRecoveredEntry(key, value);
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
        throw new IllegalStateException("destroyRecoveredEntry should not be called during recovery");
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        throw new IllegalStateException("copyRecoveredEntries should not be called during recovery");
    }

    @Override
    public void foreachRegionEntry(LocalRegion.RegionEntryCallback callback) {
        throw new IllegalStateException("foreachRegionEntry should not be called during recovery");
    }

    @Override
    public boolean lruLimitExceeded() {
        return this.getRecoveredEntryMap().lruLimitExceeded(this);
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return this.getDiskStore().getDiskStoreID();
    }

    @Override
    public void acquireReadLock() {
    }

    @Override
    public void releaseReadLock() {
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newSize, int bytesOnDisk) {
    }

    @Override
    public int calculateValueSize(Object val) {
        return 0;
    }

    @Override
    public RegionMap getRegionMap() {
        return this.getRecoveredEntryMap();
    }

    @Override
    public void close() {
        RegionMap rm = this.getRecoveredEntryMap();
        if (rm != null) {
            rm.close(null);
        }
    }

    @Override
    public void handleDiskAccessException(DiskAccessException dae) {
        this.getDiskStore().getCache().getLoggerI18n().error(LocalizedStrings.PlaceHolderDiskRegion_A_DISKACCESSEXCEPTION_HAS_OCCURRED_WHILE_RECOVERING_FROM_DISK, this.getName(), (Throwable)dae);
    }

    @Override
    public boolean didClearCountChange() {
        return false;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.getDiskStore().getCancelCriterion();
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public void endRead(long start, long end, long bytesRead) {
    }

    @Override
    public boolean isRegionClosed() {
        return false;
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        this.numEntriesInVM.set(numEntriesInVM);
        this.numOverflowOnDisk.set(numOverflowOnDisk);
        this.numOverflowBytesOnDisk.set(numOverflowBytesOnDisk);
    }

    @Override
    public EvictionController getExistingController(InternalRegionArguments internalArgs) {
        if (this.isBucket()) {
            return this.getDiskStore().getOrCreatePRLRUStats(this);
        }
        return null;
    }
}

