/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;

public class BackupResponse
extends AdminResponse {
    private HashSet<PersistentID> persistentIds;

    public BackupResponse() {
    }

    public BackupResponse(InternalDistributedMember sender, HashSet<PersistentID> persistentIds) {
        this.setRecipient(sender);
        this.persistentIds = persistentIds;
    }

    public Set<PersistentID> getPersistentIds() {
        return this.persistentIds;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.persistentIds = DataSerializer.readHashSet(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeHashSet(this.persistentIds, out);
    }

    @Override
    public int getDSFID() {
        return 2117;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.persistentIds;
    }
}

