/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntry;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMThinLRURegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryHeap;

public abstract class VMThinLRURegionEntryHeap
extends VMThinLRURegionEntry {
    private static final VMThinLRURegionEntryHeapFactory factory = new VMThinLRURegionEntryHeapFactory();

    public VMThinLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMThinLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMThinLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

