/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;

public class CreateMissingBucketsTask
extends RecoveryRunnable {
    public CreateMissingBucketsTask(PRHARedundancyProvider prhaRedundancyProvider) {
        super(prhaRedundancyProvider);
    }

    @Override
    public void run2() {
        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this.redundancyProvider.prRegion);
        PartitionedRegion.RecoveryLock lock = leaderRegion.getRecoveryLock();
        lock.lock();
        try {
            this.createMissingBuckets(this.redundancyProvider.prRegion);
        }
        finally {
            lock.unlock();
        }
    }

    protected void createMissingBuckets(PartitionedRegion region) {
        PartitionedRegion parentRegion = ColocationHelper.getColocatedRegion(region);
        if (parentRegion == null) {
            return;
        }
        this.createMissingBuckets(parentRegion);
        for (int i = 0; i < region.getTotalNumberOfBuckets(); ++i) {
            if (parentRegion.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy() == region.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy()) continue;
            long startTime = PartitionedRegionStats.startTime();
            region.getRedundancyProvider().createBucketAtomically(i, 0, startTime, true, null);
        }
    }
}

