/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class RemoveOverRedundancy
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        return this.removeOverRedundancy();
    }

    private boolean removeOverRedundancy() {
        Move bestMove = null;
        BucketRollup first = null;
        while (bestMove == null) {
            if (this.model.getOverRedundancyBuckets().isEmpty()) {
                return false;
            }
            first = this.model.getOverRedundancyBuckets().first();
            bestMove = this.model.findBestRemove(first);
            if (bestMove != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping overredundancy bucket {} because couldn't find a member to remove from?", (Object)first);
            }
            this.model.ignoreOverRedundancyBucket(first);
        }
        Member targetMember = bestMove.getTarget();
        this.model.remoteOverRedundancyBucket(first, targetMember);
        return true;
    }
}

