/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import org.apache.geode.distributed.DistributedMember;

public class ServerQueueStatus {
    private final int pingInterval;
    private int qSize = 0;
    private byte endpointType = 0;
    private DistributedMember memberId = null;
    private int pdxSize = 0;

    public ServerQueueStatus(byte endpointType, int queueSize, DistributedMember memberId, int pingInterval) {
        this.qSize = queueSize;
        this.endpointType = endpointType;
        this.memberId = memberId;
        this.pingInterval = pingInterval;
    }

    public ServerQueueStatus(byte endpointType, int queueSize, DistributedMember memberId) {
        this.qSize = queueSize;
        this.endpointType = endpointType;
        this.memberId = memberId;
        this.pingInterval = -1;
    }

    public boolean isPrimary() {
        return this.endpointType == 2;
    }

    public boolean isRedundant() {
        return this.endpointType == 1;
    }

    public boolean isNonRedundant() {
        return this.endpointType == 0;
    }

    public int getServerQueueSize() {
        return this.qSize;
    }

    public int getPingInterval() {
        if (this.pingInterval < 0) {
            throw new IllegalStateException("ping interval is only known for a subscription feed connection");
        }
        return this.pingInterval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ServerQueueStatus [").append("queueSize=").append(this.qSize).append("; endpointType=").append(this.getTypeAsString()).append("; pingInterval=").append(this.pingInterval).append("ms]");
        return buffer.toString();
    }

    protected String getTypeAsString() {
        String type = null;
        type = this.isNonRedundant() ? "NON_REDUNDANT" : (this.isRedundant() ? "REDUNDANT" : "PRIMARY");
        return type;
    }

    public int getPdxSize() {
        return this.pdxSize;
    }

    public void setPdxSize(int pdxSize) {
        this.pdxSize = pdxSize;
    }

    public DistributedMember getMemberId() {
        return this.memberId;
    }
}

