/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class CreateRegion
extends BaseCommand {
    private static final CreateRegion singleton = new CreateRegion();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        Region<Object, Object> region;
        Part regionNamePart = null;
        String regionName = null;
        serverConnection.setAsTrue(2);
        Part parentRegionNamePart = clientMessage.getPart(0);
        String parentRegionName = parentRegionNamePart.getString();
        regionNamePart = clientMessage.getPart(1);
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received create region request ({} bytes) from {} for parent region {} region {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)parentRegionName, (Object)regionName);
        }
        if (parentRegionName == null || regionName == null) {
            String errMessage = "";
            if (parentRegionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, serverConnection.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            CreateRegion.writeErrorResponse(clientMessage, 30, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region parentRegion = serverConnection.getCache().getRegion(parentRegionName);
        if (parentRegion == null) {
            String reason = LocalizedStrings.CreateRegion__0_WAS_NOT_FOUND_DURING_SUBREGION_CREATION_REQUEST.toLocalizedString(parentRegionName);
            CreateRegion.writeRegionDestroyedEx(clientMessage, parentRegionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.MANAGE);
        }
        catch (NotAuthorizedException ex) {
            CreateRegion.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null) {
            try {
                authzRequest.createRegionAuthorize(parentRegionName + '/' + regionName);
            }
            catch (NotAuthorizedException ex) {
                CreateRegion.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if ((region = parentRegion.getSubregion(regionName)) == null) {
            AttributesFactory factory = new AttributesFactory(parentRegion.getAttributes());
            region = parentRegion.createSubregion(regionName, factory.create());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Created region {}", (Object)serverConnection.getName(), region);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Retrieved region {}", (Object)serverConnection.getName(), region);
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent create region response for parent region {} region {}", (Object)serverConnection.getName(), (Object)parentRegionName, (Object)regionName);
        }
    }
}

