/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender65;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteFunction65
extends BaseCommand {
    private static final ExecuteFunction65 singleton = new ExecuteFunction65();

    public static Command getCommand() {
        return singleton;
    }

    ExecuteFunction65() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        boolean isReexecute;
        byte functionState;
        byte hasResult;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        block29: {
            function = null;
            args = null;
            memberMappedArg = null;
            hasResult = 0;
            functionState = 0;
            isReexecute = false;
            try {
                functionState = clientMessage.getPart(0).getSerializedForm()[0];
                if (functionState == 11) {
                    functionState = 3;
                    isReexecute = true;
                } else if (functionState == 15) {
                    functionState = 7;
                    isReexecute = true;
                }
                hasResult = functionState != 1 ? (byte)((byte)((functionState & 2) - 1)) : functionState;
                if (hasResult == 1) {
                    serverConnection.setAsTrue(2);
                    serverConnection.setAsTrue(3);
                }
                function = clientMessage.getPart(1).getStringOrObject();
                args = clientMessage.getPart(2).getObject();
                Part part = clientMessage.getPart(3);
                if (part != null) {
                    memberMappedArg = (MemberMappedArgument)part.getObject();
                }
            }
            catch (ClassNotFoundException exception) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
                if (hasResult != true) break block29;
                ExecuteFunction65.writeChunkedException(clientMessage, exception, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (function == null) {
            String message = LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        try {
            Function functionObject = null;
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", (Object)functionStateOnServerSide, (Object)functionState);
                }
                if (functionStateOnServerSide != functionState) {
                    String message = LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStats.getFunctionStats(functionObject.getId());
            functionObject.getRequiredPermissions(null).forEach(securityService::authorize);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage m = serverConnection.getFunctionResponseMessage();
            m.setTransactionId(clientMessage.getTransactionId());
            ServerToClientFunctionResultSender65 resultSender = new ServerToClientFunctionResultSender65(m, 63, serverConnection, functionObject, executeContext);
            FunctionContextImpl context = null;
            InternalCache cache = serverConnection.getCache();
            InternalDistributedMember localVM = (InternalDistributedMember)cache.getDistributedSystem().getDistributedMember();
            context = memberMappedArg != null ? new FunctionContextImpl(cache, functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender, isReexecute) : new FunctionContextImpl(cache, functionObject.getId(), args, resultSender, isReexecute);
            ServerSideHandshake handshake = serverConnection.getHandshake();
            int earlierClientReadTimeout = handshake.getClientReadTimeout();
            handshake.setClientReadTimeout(0);
            try {
                long startExecution = stats.startTime();
                stats.startFunctionExecution(functionObject.hasResult());
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", (Object)serverConnection, (Object)context);
                }
                HeapMemoryMonitor hmm = ((InternalResourceManager)cache.getResourceManager()).getHeapMonitor();
                if (functionObject.optimizeForWrite() && cache != null && hmm.getState().isCritical() && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
                    Set<DistributedMember> sm = Collections.singleton(cache.getMyId());
                    LowMemoryException e = new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(functionObject.getId(), sm), sm);
                    this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
                    return;
                }
                functionObject.execute(context);
                if (!resultSender.isLastResultReceived() && functionObject.hasResult()) {
                    throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(functionObject.getId()));
                }
                stats.endFunctionExecution(startExecution, functionObject.hasResult());
            }
            catch (FunctionException functionException) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw functionException;
            }
            catch (Exception exception) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw new FunctionException(exception);
            }
            finally {
                handshake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException ioException) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioException);
            String message = LocalizedStrings.ExecuteFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, clientMessage, message, serverConnection, ioException);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)internalfunctionException);
            }
            String message = internalfunctionException.getMessage();
            this.sendException(hasResult, clientMessage, message, serverConnection, internalfunctionException);
        }
        catch (Exception e) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, clientMessage, message, serverConnection, e);
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseException(msg, 2, serverConnection, e);
            serverConnection.setAsTrue(1);
        }
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseError(msg, 64, message, serverConnection);
            serverConnection.setAsTrue(1);
        }
    }
}

