/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Invalidate;
import org.apache.geode.internal.cache.versions.VersionTag;

public class Invalidate70
extends Invalidate {
    private static final Invalidate70 singleton = new Invalidate70();

    public static Command getCommand() {
        return singleton;
    }

    private Invalidate70() {
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            replyMsg.addObjPart(versionTag);
        }
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADATA tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn, VersionTag versionTag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        int flags = 0;
        int numParts = 2;
        if (versionTag != null) {
            flags |= 1;
            ++numParts;
        }
        replyMsg.setNumberOfParts(numParts);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addIntPart(flags);
        if (versionTag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("wrote version tag in response: {}", (Object)versionTag);
            }
            replyMsg.addObjPart(versionTag);
        } else if (logger.isDebugEnabled()) {
            logger.debug("response has no version tag");
        }
        replyMsg.addBytesPart(Invalidate70.okBytes());
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }
}

