/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.tx.RemoteFetchKeysMessage;
import org.apache.geode.internal.cache.tx.RemoteSizeMessage;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class AbstractPeerTXRegionStub
implements TXRegionStub {
    protected final TXStateStub state;

    public AbstractPeerTXRegionStub(TXStateStub txstate) {
        this.state = txstate;
    }

    protected abstract InternalRegion getRegion();

    @Override
    public Set getRegionKeysForIteration() {
        try {
            RemoteFetchKeysMessage.FetchKeysResponse response = RemoteFetchKeysMessage.send((LocalRegion)this.getRegion(), this.state.getTarget());
            return response.waitForKeys();
        }
        catch (RegionDestroyedException e) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(e.getRegionFullPath()), e);
        }
        catch (CacheClosedException e) {
            throw new TransactionDataNodeHasDepartedException("Cache was closed while fetching keys");
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public int entryCount() {
        try {
            RemoteSizeMessage.SizeResponse response = RemoteSizeMessage.send(this.state.getTarget(), this.getRegion());
            return response.waitForSize();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }
}

