/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.DataSerializable;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.versions.RVVException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RegionVersionHolder<T>
implements Cloneable,
DataSerializable {
    private static final Logger logger = LogService.getLogger();
    private static List<RVVException> EMPTY_EXCEPTIONS = Collections.emptyList();
    long version = -1L;
    transient T id;
    private List<RVVException> exceptions;
    boolean isDepartedMember;
    public static int BIT_SET_WIDTH = 1024;
    private long bitSetVersion = 1L;
    private BitSet bitSet;

    public RegionVersionHolder(long ver) {
        this.version = ver;
    }

    public RegionVersionHolder(T id) {
        this.id = id;
        this.version = 0L;
        this.bitSetVersion = 1L;
        this.bitSet = new BitSet(BIT_SET_WIDTH);
    }

    public RegionVersionHolder(DataInput in) throws IOException {
        this.fromData(in);
    }

    public synchronized long getVersion() {
        RVVException e = null;
        List<RVVException> exs = this.getExceptions();
        if (!exs.isEmpty()) {
            e = exs.get(0);
        }
        if (this.isSpecialException(e, this)) {
            return e.getHighestReceivedVersion();
        }
        return this.version;
    }

    private synchronized RVVException getSpecialException() {
        RVVException e = null;
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            e = this.exceptions.get(0);
        }
        if (this.isSpecialException(e, this)) {
            return e;
        }
        return null;
    }

    public long getBitSetVersionForTesting() {
        return this.bitSetVersion;
    }

    private synchronized List<RVVException> getExceptions() {
        this.mergeBitSet();
        if (this.exceptions != null) {
            return this.exceptions;
        }
        return EMPTY_EXCEPTIONS;
    }

    public synchronized List<RVVException> getExceptionForTest() {
        return this.getExceptions();
    }

    public synchronized int getExceptionCount() {
        return this.getExceptions().size();
    }

    public synchronized String exceptionsToString() {
        return this.getExceptions().toString();
    }

    public void setVersion(long ver) {
        this.version = ver;
    }

    public synchronized RegionVersionHolder<T> clone() {
        RegionVersionHolder<long> clone = new RegionVersionHolder<long>(this.version);
        clone.id = this.id;
        clone.isDepartedMember = this.isDepartedMember;
        if (this.exceptions != null) {
            clone.exceptions = new LinkedList<RVVException>();
            for (RVVException e : this.exceptions) {
                clone.exceptions.add(e.clone());
            }
        }
        if (this.bitSet != null) {
            clone.bitSet = (BitSet)this.bitSet.clone();
            clone.bitSetVersion = this.bitSetVersion;
            super.mergeBitSet();
        }
        return clone;
    }

    public synchronized String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{rv").append(this.version).append(" bsv").append(this.bitSetVersion).append(" bs=[");
        if (this.bitSet != null && (i = this.bitSet.nextSetBit(0)) >= 0) {
            sb.append("0");
            i = this.bitSet.nextSetBit(1);
            while (i > 0) {
                sb.append(',').append(i);
                i = this.bitSet.nextSetBit(i + 1);
            }
        }
        sb.append(']');
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append(this.exceptions.toString());
        }
        return sb.toString();
    }

    private void addOlderVersion(long missingVersion) {
        if (this.exceptions == null) {
            return;
        }
        int i = 0;
        Iterator<RVVException> it = this.exceptions.iterator();
        while (it.hasNext()) {
            RVVException e = it.next();
            if (e.nextVersion <= missingVersion) {
                return;
            }
            if (e.previousVersion < missingVersion && missingVersion < e.nextVersion) {
                String fine = null;
                if (logger.isTraceEnabled(LogMarker.RVV_VERBOSE)) {
                    fine = e.toString();
                }
                e.add(missingVersion);
                if (e.isFilled()) {
                    if (fine != null) {
                        logger.trace(LogMarker.RVV_VERBOSE, "Filled exception {}", (Object)fine);
                    }
                    it.remove();
                } else if (e.shouldChangeForm()) {
                    this.exceptions.set(i, e.changeForm());
                }
                if (this.exceptions.isEmpty()) {
                    this.exceptions = null;
                }
                return;
            }
            ++i;
        }
    }

    void flushBitSetDuringRecording(long version) {
        if (this.bitSetVersion + (long)BIT_SET_WIDTH - 1L >= version) {
            return;
        }
        int length = BIT_SET_WIDTH;
        int bitCountToFlush = length * 3 / 4;
        if (logger.isTraceEnabled(LogMarker.RVV_VERBOSE)) {
            logger.trace(LogMarker.RVV_VERBOSE, "flushing RVV bitset bitSetVersion={}; bits={}", (Object)this.bitSetVersion, (Object)this.bitSet);
        }
        if (version >= this.bitSetVersion + (long)length + (long)bitCountToFlush) {
            this.addBitSetExceptions(length, version);
        } else {
            this.addBitSetExceptions(bitCountToFlush, this.bitSetVersion + (long)bitCountToFlush);
        }
        if (logger.isTraceEnabled(LogMarker.RVV_VERBOSE)) {
            logger.trace(LogMarker.RVV_VERBOSE, "After flushing bitSetVersion={}; bits={}", (Object)this.bitSetVersion, (Object)this.bitSet);
        }
    }

    private synchronized void mergeBitSet() {
        if (this.bitSet != null && this.bitSetVersion < this.version) {
            this.addBitSetExceptions((int)(this.version - this.bitSetVersion), this.version);
        }
    }

    private void addBitSetExceptions(int numBits, long newVersion) {
        int nextMissingIndex;
        boolean isDebugEnabled_RVV = logger.isTraceEnabled(LogMarker.RVV_VERBOSE);
        int lastSetIndex = -1;
        if (isDebugEnabled_RVV) {
            logger.trace(LogMarker.RVV_VERBOSE, "addBitSetExceptions({},{})", (Object)numBits, (Object)newVersion);
        }
        int idx = 0;
        while (idx < numBits && (nextMissingIndex = this.bitSet.nextClearBit(idx)) >= 0) {
            lastSetIndex = nextMissingIndex - 1;
            int nextReceivedIndex = this.bitSet.nextSetBit(nextMissingIndex + 1);
            long nextReceivedVersion = -1L;
            if (nextReceivedIndex > 0) {
                lastSetIndex = nextReceivedIndex;
                nextReceivedVersion = (long)nextReceivedIndex + this.bitSetVersion;
                idx = nextReceivedIndex + 1;
                if (isDebugEnabled_RVV) {
                    logger.trace(LogMarker.RVV_VERBOSE, "found gap in bitSet: missing bit at index={}; next set index={}", (Object)nextMissingIndex, (Object)nextReceivedIndex);
                }
            } else {
                if (isDebugEnabled_RVV) {
                    logger.trace(LogMarker.RVV_VERBOSE, "terminating flush at bit {} because of missing entries", (Object)lastSetIndex);
                }
                this.bitSetVersion += (long)lastSetIndex;
                this.bitSet.clear();
                if (lastSetIndex != -1) {
                    this.bitSet.set(0);
                }
                return;
            }
            long nextMissingVersion = Math.max(1L, (long)nextMissingIndex + this.bitSetVersion);
            if (nextReceivedVersion <= nextMissingVersion) continue;
            this.addException(nextMissingVersion - 1L, nextReceivedVersion);
            if (!isDebugEnabled_RVV) continue;
            logger.trace(LogMarker.RVV_VERBOSE, "Added rvv exception e<rv{} - rv{}>", (Object)(nextMissingVersion - 1L), (Object)nextReceivedVersion);
        }
        this.bitSet = this.bitSet.get(lastSetIndex, Math.max(lastSetIndex + 1, this.bitSet.size()));
        if (lastSetIndex > 0) {
            this.bitSetVersion += (long)lastSetIndex;
        }
    }

    synchronized void recordVersion(long version) {
        if (this.bitSet != null) {
            this.recordVersionWithBitSet(version);
        } else {
            this.recordVersionWithoutBitSet(version);
        }
    }

    private void recordVersionWithoutBitSet(long version) {
        if (version - this.version > 1L) {
            this.addException(this.version, version);
            this.logRecordVersion(version);
            this.version = version;
            return;
        }
        if (this.version > version) {
            this.addOlderVersion(version);
        }
        this.version = Math.max(this.version, version);
    }

    private void recordVersionWithBitSet(long version) {
        if (this.version == version) {
            if (version >= this.bitSetVersion) {
                this.setVersionInBitSet(version);
            }
            this.addOlderVersion(version);
            return;
        }
        this.flushBitSetDuringRecording(version);
        if (version >= this.bitSetVersion) {
            if (this.getSpecialException() != null) {
                this.addOlderVersion(version);
            }
            this.setVersionInBitSet(version);
            this.version = Math.max(this.version, version);
            return;
        }
        this.addOlderVersion(version);
        this.version = Math.max(this.version, version);
    }

    private void setVersionInBitSet(long version) {
        this.bitSet.set((int)(version - this.bitSetVersion));
    }

    private void logRecordVersion(long version) {
        if (logger.isTraceEnabled(LogMarker.RVV_VERBOSE)) {
            logger.trace(LogMarker.RVV_VERBOSE, "Added rvv exception e<rv{} - rv{}>", (Object)this.version, (Object)version);
        }
    }

    protected synchronized void addException(long previousVersion, long nextVersion) {
        if (this.exceptions == null) {
            this.exceptions = new LinkedList<RVVException>();
        }
        int i = 0;
        for (RVVException e : this.exceptions) {
            if (previousVersion >= e.nextVersion) {
                RVVException except = RVVException.createException(previousVersion, nextVersion);
                this.exceptions.add(i, except);
                return;
            }
            ++i;
        }
        this.exceptions.add(RVVException.createException(previousVersion, nextVersion));
    }

    synchronized void removeExceptionsOlderThan(long v) {
        this.mergeBitSet();
        if (this.exceptions != null) {
            Iterator<RVVException> it = this.exceptions.iterator();
            while (it.hasNext()) {
                RVVException e = it.next();
                if (e.nextVersion > v) continue;
                it.remove();
            }
            if (this.exceptions.isEmpty()) {
                this.exceptions = null;
            }
        }
    }

    public synchronized void initializeFrom(RegionVersionHolder<T> source) {
        this.mergeBitSet();
        Object other = source.clone();
        super.mergeBitSet();
        long myVersion = this.version;
        this.exceptions = ((RegionVersionHolder)other).exceptions;
        this.version = ((RegionVersionHolder)other).version;
        if (this.bitSet != null) {
            this.bitSetVersion = this.version;
            this.bitSet.set(0);
        }
        if (myVersion > this.version) {
            RVVException e = RVVException.createException(this.version, myVersion + 1L);
            if (this.exceptions == null) {
                this.exceptions = new LinkedList<RVVException>();
            }
            int i = 0;
            for (RVVException exception : this.exceptions) {
                if (e.compareTo(exception) >= 0) break;
                ++i;
            }
            this.exceptions.add(i, e);
            this.version = myVersion;
        }
    }

    void makeReadyForRecording() {
        if (this.bitSet == null) {
            this.bitSet = new BitSet(BIT_SET_WIDTH);
            this.bitSetVersion = this.version;
            this.bitSet.set(0);
        }
    }

    synchronized boolean contains(long v) {
        if (v > this.getVersion()) {
            return false;
        }
        if (this.bitSet != null && v >= this.bitSetVersion) {
            return this.bitSet.get((int)(v - this.bitSetVersion));
        }
        if (this.exceptions == null) {
            return true;
        }
        for (RVVException e : this.exceptions) {
            if (e.nextVersion <= v) {
                return true;
            }
            if (e.previousVersion >= v || v >= e.nextVersion) continue;
            return e.contains(v);
        }
        return true;
    }

    synchronized boolean hasExceptionFor(long v) {
        if (this.bitSet != null && v >= this.bitSetVersion) {
            if (v > this.bitSetVersion + (long)this.bitSet.length()) {
                return false;
            }
            return this.bitSet.get((int)(v - this.bitSetVersion));
        }
        if (this.exceptions == null) {
            return false;
        }
        for (RVVException e : this.exceptions) {
            if (e.nextVersion <= v) {
                return false;
            }
            if (e.previousVersion >= v || v >= e.nextVersion) continue;
            return !e.contains(v);
        }
        return false;
    }

    public boolean dominates(RegionVersionHolder<T> other) {
        return !other.isNewerThanOrCanFillExceptionsFor(this);
    }

    public boolean isSpecialException(RVVException e, RegionVersionHolder holder) {
        return e != null && e.nextVersion == holder.version + 1L;
    }

    public synchronized boolean isNewerThanOrCanFillExceptionsFor(RegionVersionHolder<T> source) {
        RVVException otherException;
        if (source == null || this.getVersion() > source.getVersion()) {
            return true;
        }
        Object other = source.clone();
        this.mergeBitSet();
        super.mergeBitSet();
        List<RVVException> mine = this.canonicalExceptions(this.exceptions);
        Iterator<RVVException> myIterator = mine.iterator();
        List<RVVException> his = this.canonicalExceptions(((RegionVersionHolder)other).exceptions);
        Iterator<RVVException> otherIterator = his.iterator();
        RVVException myException = myIterator.hasNext() ? myIterator.next() : null;
        RVVException rVVException = otherException = otherIterator.hasNext() ? otherIterator.next() : null;
        while (otherException != null && otherException.previousVersion > this.version || this.isSpecialException(otherException, (RegionVersionHolder)other)) {
            otherException = otherIterator.hasNext() ? otherIterator.next() : null;
        }
        while (otherException != null) {
            if (myException == null) {
                return true;
            }
            if (this.isSpecialException(myException, this)) {
                myException = myIterator.hasNext() ? myIterator.next() : null;
                continue;
            }
            if (this.isSpecialException(otherException, (RegionVersionHolder)other)) {
                otherException = otherIterator.hasNext() ? otherIterator.next() : null;
                continue;
            }
            if (myException.previousVersion >= otherException.nextVersion) {
                myException = myIterator.hasNext() ? myIterator.next() : null;
                continue;
            }
            if (otherException.previousVersion >= myException.nextVersion) {
                return true;
            }
            if (myException.previousVersion == otherException.previousVersion && myException.nextVersion == otherException.nextVersion) {
                myException = myIterator.hasNext() ? myIterator.next() : null;
                otherException = otherIterator.hasNext() ? otherIterator.next() : null;
                continue;
            }
            if (otherException.previousVersion < myException.previousVersion || myException.nextVersion < otherException.nextVersion) {
                return true;
            }
            otherException = otherIterator.hasNext() ? otherIterator.next() : null;
        }
        return false;
    }

    @Override
    public synchronized void toData(DataOutput out) throws IOException {
        this.mergeBitSet();
        InternalDataSerializer.writeUnsignedVL(this.version, out);
        int size = this.exceptions == null ? 0 : this.exceptions.size();
        InternalDataSerializer.writeUnsignedVL(size, out);
        out.writeBoolean(this.isDepartedMember);
        if (size > 0) {
            for (RVVException e : this.exceptions) {
                InternalDataSerializer.invokeToData(e, out);
            }
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        this.version = InternalDataSerializer.readUnsignedVL(in);
        int size = (int)InternalDataSerializer.readUnsignedVL(in);
        this.isDepartedMember = in.readBoolean();
        if (size > 0) {
            this.exceptions = new LinkedList<RVVException>();
            for (int i = 0; i < size; ++i) {
                RVVException e = RVVException.createException(in);
                this.exceptions.add(e);
            }
        }
    }

    public synchronized int hashCode() {
        this.mergeBitSet();
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.version;
        result = 31 * result + (int)(this.version >> 32);
        result = 31 * result + this.canonicalExceptions(this.exceptions).hashCode();
        return result;
    }

    void removeSpecialException() {
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            Iterator<RVVException> it = this.exceptions.iterator();
            while (it.hasNext()) {
                RVVException e = it.next();
                if (!this.isSpecialException(e, this)) continue;
                it.remove();
            }
            if (this.exceptions.isEmpty()) {
                this.exceptions = null;
            }
        }
    }

    public synchronized boolean sameAs(RegionVersionHolder<T> other) {
        this.mergeBitSet();
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Object vh1 = this.clone();
        Object vh2 = other.clone();
        ((RegionVersionHolder)vh1).removeSpecialException();
        ((RegionVersionHolder)vh2).removeSpecialException();
        if (((RegionVersionHolder)vh1).exceptions == null || ((RegionVersionHolder)vh1).exceptions.isEmpty()) {
            return ((RegionVersionHolder)vh2).exceptions == null || ((RegionVersionHolder)vh2).exceptions.isEmpty();
        }
        List<RVVException> e1 = this.canonicalExceptions(((RegionVersionHolder)vh1).exceptions);
        List<RVVException> e2 = this.canonicalExceptions(((RegionVersionHolder)vh2).exceptions);
        Iterator<RVVException> it1 = e1.iterator();
        Iterator<RVVException> it2 = e2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next().sameAs(it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RegionVersionHolder)) {
            return false;
        }
        return this.sameAs((RegionVersionHolder)obj);
    }

    protected List<RVVException> canonicalExceptions(List<RVVException> exceptions) {
        LinkedList<RVVException> canon = new LinkedList<RVVException>();
        if (exceptions != null) {
            for (RVVException exception : exceptions) {
                if (exception.isEmpty()) {
                    canon.add(exception);
                    continue;
                }
                long previous = exception.previousVersion;
                int insertAt = canon.size();
                RVVException.ReceivedVersionsIterator it = exception.receivedVersionsIterator();
                while (it.hasNext()) {
                    Long received = it.next();
                    if (received != previous + 1L) {
                        canon.add(insertAt, RVVException.createException(previous, received));
                    }
                    previous = received;
                }
                if (exception.nextVersion == previous + 1L) continue;
                canon.add(insertAt, RVVException.createException(previous, exception.nextVersion));
            }
        }
        return canon;
    }
}

