/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.util.Gateway;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GatewaySenderAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private DistributedLockService lockService;
    private volatile boolean isPrimary;
    private final Object primaryLock = new Object();
    private final String lockToken;
    private Thread lockObtainingThread;
    private final ThreadGroup threadGroup = LoggingThreadGroup.createThreadGroup("GatewaySenderAdvisor Threads");
    private AbstractGatewaySender sender;

    private GatewaySenderAdvisor(DistributionAdvisee sender) {
        super(sender);
        this.sender = (AbstractGatewaySender)sender;
        this.lockToken = this.getDLockServiceName() + "-token";
    }

    public static GatewaySenderAdvisor createGatewaySenderAdvisor(DistributionAdvisee sender) {
        GatewaySenderAdvisor advisor = new GatewaySenderAdvisor(sender);
        advisor.initialize();
        return advisor;
    }

    public String getDLockServiceName() {
        return this.getClass().getName() + "_" + this.sender.getId();
    }

    public Thread getLockObtainingThread() {
        return this.lockObtainingThread;
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new GatewaySenderProfile(memberId, version);
    }

    @Override
    public void profileCreated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            this.checkCompatibility(sp);
        }
    }

    private void checkCompatibility(GatewaySenderProfile sp) {
        if (sp.remoteDSId != this.sender.getRemoteDSId()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_REMOTE_DS_ID_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_2_REMOTE_DS_ID.toString(sp.Id, sp.remoteDSId, this.sender.remoteDSId));
        }
        if (sp.isParallel && !this.sender.isParallel()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_AS_PARALLEL_GATEWAY_SENDER_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_AS_SERIAL_GATEWAY_SENDER.toString(sp.Id));
        }
        if (!sp.isParallel && this.sender.isParallel()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_AS_SERIAL_GATEWAY_SENDER_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_AS_PARALLEL_GATEWAY_SENDER.toString(sp.Id));
        }
        if (sp.isBatchConflationEnabled != this.sender.isBatchConflationEnabled()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_IS_BACTH_CONFLATION_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_IS_BATCH_CONFLATION_2.toString(sp.Id, sp.isBatchConflationEnabled, this.sender.isBatchConflationEnabled()));
        }
        if (sp.isPersistenceEnabled != this.sender.isPersistenceEnabled()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_IS_PERSISTENT_ENABLED_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_IS_PERSISTENT_ENABLED_2.toString(sp.Id, sp.isPersistenceEnabled, this.sender.isPersistenceEnabled()));
        }
        if (sp.alertThreshold != this.sender.getAlertThreshold()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_ALERT_THRESHOLD_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_ALERT_THRESHOLD_2.toString(sp.Id, sp.alertThreshold, this.sender.getAlertThreshold()));
        }
        if (!this.sender.isParallel() && sp.manualStart != this.sender.isManualStart()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_MANUAL_START_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_MANUAL_START_2.toString(sp.Id, sp.manualStart, this.sender.isManualStart()));
        }
        if (!sp.isParallel && sp.orderPolicy != this.sender.getOrderPolicy()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_ORDER_POLICY_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_ORDER_POLICY_2.toString(new Object[]{sp.Id, sp.orderPolicy, this.sender.getOrderPolicy()}));
        }
        ArrayList<String> senderEventFilterClassNames = new ArrayList<String>();
        for (GatewayEventFilter gatewayEventFilter : this.sender.getGatewayEventFilters()) {
            senderEventFilterClassNames.add(gatewayEventFilter.getClass().getName());
        }
        if (sp.eventFiltersClassNames.size() != senderEventFilterClassNames.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_EVENT_FILTERS_MISMATCH.toString(sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        for (String string : senderEventFilterClassNames) {
            if (sp.eventFiltersClassNames.contains(string)) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_EVENT_FILTERS_MISMATCH.toString(sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        LinkedHashSet<String> senderTransportFilterClassNames = new LinkedHashSet<String>();
        for (GatewayTransportFilter filter : this.sender.getGatewayTransportFilters()) {
            senderTransportFilterClassNames.add(filter.getClass().getName());
        }
        if (sp.transFiltersClassNames.size() != senderTransportFilterClassNames.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_TRANSPORT_FILTERS_MISMATCH.toString(sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        Iterator<String> iterator = sp.transFiltersClassNames.iterator();
        Iterator i2 = senderTransportFilterClassNames.iterator();
        while (iterator.hasNext() && i2.hasNext()) {
            if (iterator.next().equals(i2.next())) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_TRANSPORT_FILTERS_MISMATCH.toString(sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AsyncEventListener listener : this.sender.getAsyncEventListeners()) {
            arrayList.add(listener.getClass().getName());
        }
        if (sp.senderEventListenerClassNames.size() != arrayList.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_LISTENER_MISMATCH.toString(sp.Id, sp.senderEventListenerClassNames, arrayList));
        }
        for (String listenerName : arrayList) {
            if (sp.senderEventListenerClassNames.contains(listenerName)) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_LISTENER_MISMATCH.toString(sp.Id, sp.senderEventListenerClassNames, arrayList));
        }
        if (sp.isDiskSynchronous != this.sender.isDiskSynchronous()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_IS_DISK_SYNCHRONOUS_MISMATCH.toString(sp.Id, sp.isDiskSynchronous, this.sender.isDiskSynchronous()));
        }
    }

    @Override
    public void profileUpdated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (!sp.isRunning) {
                    if (this.advisePrimaryGatewaySender() != null) {
                        return;
                    }
                    if (!this.sender.isPrimary()) {
                        if (!this.adviseEldestGatewaySender()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                            }
                            return;
                        }
                        this.launchLockObtainingVolunteerThread();
                    }
                } else if (sp.serverLocation != null) {
                    this.sender.setServerLocation(sp.serverLocation);
                }
            }
        }
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (this.advisePrimaryGatewaySender() != null) {
                    return;
                }
                if (!this.sender.isPrimary()) {
                    if (!this.adviseEldestGatewaySender()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                        }
                        return;
                    }
                    this.launchLockObtainingVolunteerThread();
                }
            }
        }
    }

    public boolean isPrimary() {
        return this.sender.isParallel() || this.isPrimary;
    }

    public void initDLockService() {
        InternalDistributedSystem ds = this.sender.getCache().getInternalDistributedSystem();
        String dlsName = this.getDLockServiceName();
        this.lockService = DistributedLockService.getServiceNamed(dlsName);
        if (this.lockService == null) {
            this.lockService = DLockService.create(dlsName, ds, true, true, true);
        }
        Assert.assertTrue(this.lockService != null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Obtained DistributedLockService: {}", (Object)this, (Object)this.lockService);
        }
    }

    public boolean volunteerForPrimary() {
        if (logger.isDebugEnabled()) {
            logger.debug("Sender : {} is volunteering for Primary ", (Object)this.sender.getId());
        }
        if (this.advisePrimaryGatewaySender() == null) {
            if (!this.adviseEldestGatewaySender()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Sender : {} no Primary available. So going to acquire distributed lock", (Object)this.sender);
            }
            this.lockService.lock(this.lockToken, 10000L, -1L);
            return this.lockService.isHeldByCurrentThread(this.lockToken);
        }
        return false;
    }

    private boolean adviseEldestGatewaySender() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        TreeSet<Long> senderStartTimes = new TreeSet<Long>();
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            senderStartTimes.add(sp.startTime);
        }
        return senderStartTimes.isEmpty() || this.sender.isRunning() && this.sender.startTime <= (Long)senderStartTimes.first();
    }

    private InternalDistributedMember adviseEldestGatewaySenderNode() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        InternalDistributedMember node = null;
        DistributionAdvisor.Profile eldestProfile = null;
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            if (eldestProfile == null) {
                eldestProfile = sp;
            }
            if (sp.startTime >= ((GatewaySenderProfile)eldestProfile).startTime) continue;
            eldestProfile = sp;
        }
        if (eldestProfile != null) {
            node = eldestProfile.getDistributedMember();
        }
        return node;
    }

    public void makePrimary() {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_PRIMARY, this.sender));
        AbstractGatewaySenderEventProcessor eventProcessor = this.sender.getEventProcessor();
        if (eventProcessor != null) {
            eventProcessor.removeCacheListener();
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__BECOMING_PRIMARY_GATEWAYSENDER, this.sender));
        this.notifyAndBecomePrimary();
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAndBecomePrimary() {
        Object object = this.primaryLock;
        synchronized (object) {
            this.setIsPrimary(true);
            this.notifyPrimaryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPrimaryLock() {
        Object object = this.primaryLock;
        synchronized (object) {
            this.primaryLock.notifyAll();
        }
    }

    public void makeSecondary() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Did not obtain the lock on {}. Starting as secondary gateway sender.", (Object)this.sender, (Object)this.lockToken);
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_SECONDARY_BECAUSE_PRIMARY_GATEWAY_SENDER_IS_AVAIALABLE_ON_MEMBER_2, new Object[]{this.sender.getId(), this.advisePrimaryGatewaySender()}));
        this.isPrimary = false;
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    public void launchLockObtainingVolunteerThread() {
        this.lockObtainingThread = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                GatewaySenderAdvisor.this.sender.getLifeCycleLock().readLock().lock();
                try {
                    if (!GatewaySenderAdvisor.this.sender.isRunning()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Obtaining the lock on {}", (Object)this, (Object)GatewaySenderAdvisor.this.lockToken);
                    }
                    if (GatewaySenderAdvisor.this.volunteerForPrimary()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Obtained the lock on {}", (Object)this, (Object)GatewaySenderAdvisor.this.lockToken);
                        }
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewaySender_0_IS_BECOMING_PRIMARY_GATEWAY_Sender, GatewaySenderAdvisor.this));
                        GatewaySenderAdvisor.this.makePrimary();
                    }
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    if (!GatewaySenderAdvisor.this.sender.getStopper().isCancelInProgress()) {
                        logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GatewaySenderAdvisor_0_THE_THREAD_TO_OBTAIN_THE_FAILOVER_LOCK_WAS_INTERRUPTED__THIS_GATEWAY_SENDER_WILL_NEVER_BECOME_THE_PRIMARY, GatewaySenderAdvisor.this), (Throwable)e);
                    }
                }
                finally {
                    GatewaySenderAdvisor.this.sender.getLifeCycleLock().readLock().unlock();
                }
            }
        }, "Gateway Sender Primary Lock Acquisition Thread Volunteer");
        this.lockObtainingThread.setDaemon(true);
        this.lockObtainingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBecomePrimary(AbstractGatewaySenderEventProcessor callingProcessor) throws InterruptedException {
        if (this.isPrimary()) {
            return;
        }
        Object object = this.primaryLock;
        synchronized (object) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__WAITING_TO_BECOME_PRIMARY_GATEWAY, this.sender.getId()));
            while (!this.isPrimary()) {
                this.primaryLock.wait(1000L);
                if (this.sender.getEventProcessor() == null || !callingProcessor.isStopped()) continue;
                logger.info("The event processor is stopped, not to wait for being primary any more.");
                return;
            }
        }
    }

    public InternalDistributedMember advisePrimaryGatewaySender() {
        DistributionAdvisor.Profile[] snapshot;
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isPrimary) continue;
            return sp.getDistributedMember();
        }
        return null;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Override
    public void close() {
        new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
        super.close();
    }

    public static class GatewaySenderProfile
    extends DistributionAdvisor.Profile {
        public String Id;
        public long startTime;
        public int remoteDSId;
        public boolean isRunning;
        public boolean isPrimary;
        public boolean isParallel;
        public boolean isBatchConflationEnabled;
        public boolean isPersistenceEnabled;
        public int alertThreshold;
        public boolean manualStart;
        public ArrayList<String> eventFiltersClassNames = new ArrayList();
        public ArrayList<String> transFiltersClassNames = new ArrayList();
        public ArrayList<String> senderEventListenerClassNames = new ArrayList();
        public boolean isDiskSynchronous;
        public int dispatcherThreads;
        public GatewaySender.OrderPolicy orderPolicy;
        public ServerLocation serverLocation;
        private static final Version[] serializationVersions = new Version[]{Version.GFE_80};

        public GatewaySenderProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public GatewaySenderProfile() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            Gateway.OrderPolicy oldOrderPolicy;
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_90) < 0 ? ((oldOrderPolicy = (Gateway.OrderPolicy)((Object)DataSerializer.readObject(in))) != null ? (oldOrderPolicy.name().equals(GatewaySender.OrderPolicy.KEY.name()) ? GatewaySender.OrderPolicy.KEY : (oldOrderPolicy.name().equals(GatewaySender.OrderPolicy.THREAD.name()) ? GatewaySender.OrderPolicy.THREAD : GatewaySender.OrderPolicy.PARTITION)) : null) : (GatewaySender.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            out.writeInt(this.dispatcherThreads);
            if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GFE_90) < 0 && this.orderPolicy != null) {
                String orderPolicyName = this.orderPolicy.name();
                if (orderPolicyName.equals(Gateway.OrderPolicy.KEY.name())) {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.KEY, out);
                } else if (orderPolicyName.equals(Gateway.OrderPolicy.THREAD.name())) {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.THREAD, out);
                } else {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.PARTITION, out);
                }
            } else {
                DataSerializer.writeObject((Object)this.orderPolicy, out);
            }
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = (GatewaySender.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            if (this.isParallel) {
                out.writeInt(1);
            } else if (this.orderPolicy == null) {
                out.writeInt(1);
            } else {
                out.writeInt(this.dispatcherThreads);
            }
            if (this.isParallel) {
                DataSerializer.writeObject(null, out);
            } else {
                DataSerializer.writeObject((Object)this.orderPolicy, out);
            }
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        @Override
        public Version[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public int getDSFID() {
            return 2144;
        }

        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            InternalCache cache = dm.getCache();
            if (cache != null) {
                AbstractGatewaySender sender = (AbstractGatewaySender)cache.getGatewaySender(adviseePath);
                this.handleDistributionAdvisee(sender, removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; id=" + this.Id);
            sb.append("; remoteDSName=" + this.remoteDSId);
            sb.append("; isRunning=" + this.isRunning);
            sb.append("; isPrimary=" + this.isPrimary);
        }
    }
}

