/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ClientCacheCreation
extends CacheCreation
implements ClientCache {
    private static final RegionAttributes clientDefaults = ClientCacheCreation.createClientDefaults();

    public ClientCacheCreation() {
        this(false);
    }

    ClientCacheCreation(boolean forParsing) {
        super(forParsing);
    }

    private static RegionAttributes createClientDefaults() {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.LOCAL);
        af.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        return af.create();
    }

    @Override
    RegionAttributes getDefaultAttributes() {
        return clientDefaults;
    }

    @Override
    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeClientRegionShortcuts(this);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getLocalQueryService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void determineDefaultPool() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut atts) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String regionAttributesId) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties, String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockLease(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setSearchTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheServer addCacheServer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setIsServer(boolean isServer) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addBackup(File backup) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    void create(InternalCache cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Object factory;
        Serializable creation;
        Map<String, Pool> pools;
        cache.setDeclarativeCacheConfig(this.getCacheConfig());
        if (!cache.isClient()) {
            throw new IllegalStateException("You must use ClientCacheFactory when the cache.xml uses client-cache.");
        }
        this.initializeDeclarablesMap(cache);
        if (this.hasFunctionService()) {
            this.getFunctionServiceCreation().create();
        }
        if (!(pools = this.getPools()).isEmpty()) {
            for (Pool cp : pools.values()) {
                PoolFactoryImpl poolFactory = (PoolFactoryImpl)PoolManager.createFactory();
                poolFactory.init(cp);
                poolFactory.create(cp.getName());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        for (DiskStore diskStore : this.listDiskStores()) {
            creation = (DiskStoreAttributesCreation)diskStore;
            if (creation == pdxRegDSC) continue;
            this.createDiskStore((DiskStoreAttributesCreation)creation, cache);
        }
        for (DiskStore diskStore : this.listDiskStores()) {
            creation = (DiskStoreAttributesCreation)diskStore;
            factory = cache.createDiskStoreFactory((DiskStoreAttributes)creation);
            factory.create(((DiskStoreAttributes)creation).getName());
        }
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.getCopyOnRead());
        }
        if (this.txMgrCreation != null && this.txMgrCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.txMgrCreation.getListeners());
        }
        if (this.txMgrCreation != null && cache.getCacheTransactionManager() != null && this.txMgrCreation.getWriter() != null) {
            throw new IllegalStateException(LocalizedStrings.TXManager_NO_WRITER_ON_CLIENT.toLocalizedString());
        }
        cache.initializePdxRegistry();
        for (String id : this.regionAttributesNames) {
            creation = (RegionAttributesCreation)this.getRegionAttributes(id);
            ((RegionAttributesCreation)creation).inheritAttributes(cache, false);
            factory = new AttributesFactory(creation);
            RegionAttributes attrs = ((AttributesFactory)factory).createRegionAttributes();
            cache.setRegionAttributes(id, attrs);
        }
        for (Region region : this.roots.values()) {
            RegionCreation regionCreation = (RegionCreation)region;
            regionCreation.createRoot(cache);
        }
        cache.readyDynamicRegionFactory();
        this.runInitializer(cache);
    }

    public String getDefaultPoolName() {
        String result = null;
        Map<String, Pool> pools = this.getPools();
        if (pools.size() == 1) {
            Pool pool = pools.values().iterator().next();
            result = pool.getName();
        } else if (pools.isEmpty()) {
            result = "DEFAULT";
        }
        return result;
    }

    @Override
    public Pool getDefaultPool() {
        return this.getPools().get(this.getDefaultPoolName());
    }

    @Override
    public boolean getPdxReadSerialized() {
        return false;
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        return Collections.emptySet();
    }

    @Override
    public void invokeRegionEntrySynchronizationListenersAfterSynchronization(InternalDistributedMember sender, InternalRegion region, List<InitialImageOperation.Entry> entriesToSynchronize) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }
}

