/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.util.StopWatch;
import org.apache.logging.log4j.Logger;

class NonBlockingProcessStreamReader
extends ProcessStreamReader {
    private static final Logger logger = LogService.getLogger();
    private final long continueReadingMillis;
    private final StopWatch continueReading;
    private StringBuilder stringBuilder;
    private int character;
    private boolean ready;

    NonBlockingProcessStreamReader(ProcessStreamReader.Builder builder) {
        super(builder);
        this.continueReadingMillis = builder.continueReadingMillis;
        this.continueReading = new StopWatch();
        this.stringBuilder = new StringBuilder();
        this.character = 0;
        this.ready = false;
    }

    @Override
    public void run() {
        block17: {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
                while (this.character != -1) {
                    this.readWhileReady(reader);
                    if (!this.shouldTerminate()) continue;
                    break;
                }
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failure reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            catch (InterruptedException e) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug("Interrupted reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private boolean shouldTerminate() throws InterruptedException {
        if (!ProcessUtils.isProcessAlive(this.process)) {
            if (!this.continueReading.isRunning()) {
                this.continueReading.start();
            } else if (this.continueReading.elapsedTimeMillis() > this.continueReadingMillis) {
                return true;
            }
        }
        Thread.sleep(10L);
        return false;
    }

    private void readWhileReady(BufferedReader reader) throws IOException {
        while ((this.ready = reader.ready()) && (this.character = reader.read()) != -1) {
            this.stringBuilder.append((char)this.character);
            if ((char)this.character != '\n') continue;
            this.inputListener.notifyInputLine(this.stringBuilder.toString());
            this.stringBuilder = new StringBuilder();
        }
    }
}

