/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import org.apache.commons.lang.Validate;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.StartupStatusListener;
import org.apache.logging.log4j.Logger;

public class StartupStatus {
    private static final Logger logger = LogService.getLogger();
    private static StartupStatusListener listener;

    private StartupStatus() {
    }

    public static synchronized void startup(StringId msgId, Object ... params) {
        Validate.notNull((Object)msgId, (String)("Invalid msgId '" + msgId + "' specified"));
        Validate.notNull((Object)params, (String)("Invalid params '" + params + "' specified"));
        String message = msgId.toLocalizedString(params);
        if (listener != null) {
            listener.setStatus(message);
        }
        logger.info(message);
    }

    public static synchronized void setListener(StartupStatusListener listener) {
        StartupStatus.listener = listener;
    }

    public static synchronized StartupStatusListener getStartupListener() {
        return listener;
    }

    public static synchronized void clearListener() {
        listener = null;
    }
}

