/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class PluckStacks {
    static boolean DEBUG = Boolean.getBoolean("PluckStacks.DEBUG");
    static final boolean ONE_STACK = Boolean.getBoolean("oneDump");

    public static void main(String[] args) throws Exception {
        PluckStacks ps = new PluckStacks();
        for (int i = 0; i < args.length; ++i) {
            ps.examineLog(new File(args[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineLog(File log) throws IOException {
        LineNumberReader reader = null;
        try {
            reader = log.getName().endsWith(".gz") ? new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(log)))) : new LineNumberReader(new FileReader(log));
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        try {
            String output;
            TreeMap<String, List<ThreadStack>> dumps = this.getThreadDumps(reader, log.getName());
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry<String, List<ThreadStack>> dump : dumps.entrySet()) {
                if (dump.getValue().size() > 0) {
                    buffer.append(dump.getKey());
                    for (ThreadStack stack : dump.getValue()) {
                        stack.appendToBuffer(buffer);
                        buffer.append("\n");
                    }
                    buffer.append("\n\n");
                }
                if (!ONE_STACK) continue;
                break;
            }
            if ((output = buffer.toString()).length() > 0) {
                System.out.println(output);
            }
        }
        finally {
            reader.close();
        }
    }

    public TreeMap<String, List<ThreadStack>> getThreadDumps(LineNumberReader reader, String logFileName) {
        TreeMap<String, List<ThreadStack>> result = new TreeMap<String, List<ThreadStack>>();
        String line = null;
        int stackNumber = 1;
        try {
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("Full thread dump") && !line.startsWith("*** Stack-trace for member ")) continue;
                int lineNumber = reader.getLineNumber();
                List<ThreadStack> stacks = this.getStacks(reader);
                if (stacks.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("[Stack #").append(stackNumber++).append(" from " + logFileName + " line " + lineNumber + "]\n").append(line).append("\n");
                    result.put(buffer.toString(), stacks);
                }
                if (!ONE_STACK) continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Something went wrong processing " + logFileName, ioe);
        }
        return result;
    }

    public List<ThreadStack> getStacks(BufferedReader reader) throws IOException {
        LinkedList<ThreadStack> result = new LinkedList<ThreadStack>();
        ThreadStack lastStack = null;
        ArrayList<String> breadcrumbs = new ArrayList<String>(4);
        do {
            String line = null;
            while (true) {
                reader.mark(100000);
                line = reader.readLine();
                if (line == null) break;
                if (line.startsWith("*** Stack-trace for member ")) {
                    reader.reset();
                    Collections.sort(result);
                    return result;
                }
                if (line.length() > 0 && line.charAt(0) == '\"') break;
                if (lastStack == null || line.length() != 0 && line.charAt(0) != '\t') continue;
                lastStack.add(line);
            }
            String firstLine = line;
            String secondLine = null;
            breadcrumbs.clear();
            while (true) {
                if ((line = reader.readLine()) == null) {
                    Collections.sort(result);
                    return result;
                }
                if (!line.startsWith("\t/")) break;
                breadcrumbs.add(line);
            }
            secondLine = line;
            line = reader.readLine();
            if (line == null) {
                Collections.sort(result);
                return result;
            }
            lastStack = new ThreadStack(firstLine, secondLine, line, reader);
            lastStack.addBreadcrumbs(breadcrumbs);
            if (DEBUG) {
                if (breadcrumbs.size() > 0) {
                    System.out.println("added " + breadcrumbs.size() + " breadcrumbs to " + lastStack.getThreadName());
                }
                System.out.println("examining thread " + lastStack.getThreadName());
            }
            if (this.isExpectedStack(lastStack)) continue;
            result.add(lastStack);
        } while (!lastStack.getThreadName().equals("VM Thread"));
        Collections.sort(result);
        return result;
    }

    boolean isExpectedStack(ThreadStack thread) {
        String threadName = thread.getThreadName();
        int stackSize = thread.size();
        if (threadName.startsWith("vm_")) {
            return false;
        }
        if (threadName.startsWith("StatDispatcher")) {
            return true;
        }
        if (threadName.startsWith("State Logger Consumer Thread")) {
            return true;
        }
        if (threadName.contains("StatSampler")) {
            return true;
        }
        if (threadName.startsWith("IDLE p2pDestreamer")) {
            return true;
        }
        if (threadName.startsWith("Idle OplogCompactor")) {
            return true;
        }
        if (threadName.startsWith("Cache Client Updater Thread")) {
            return stackSize == 13 && thread.get(2).contains("SocketInputStream.socketRead0");
        }
        if (threadName.startsWith("Client Message Dispatcher")) {
            return stackSize == 13 && thread.get(1).contains("TIMED_WAITING");
        }
        if (threadName.startsWith("Function Execution Processor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Geode Failure Detection Server")) {
            return stackSize < 11 && thread.getFirstFrame().contains("socketAccept");
        }
        if (threadName.startsWith("Geode Membership Timer")) {
            return stackSize < 9 && !thread.isRunnable();
        }
        if (threadName.startsWith("Geode Membership View Creator")) {
            return stackSize < 8 && !thread.isRunnable();
        }
        if (threadName.startsWith("Geode Heartbeat Sender")) {
            return stackSize <= 8 && !thread.isRunnable();
        }
        if (threadName.startsWith("multicast receiver")) {
            return stackSize > 2 && thread.get(2).contains("PlainDatagramSocketImpl.receive");
        }
        if (threadName.startsWith("P2P Listener")) {
            return stackSize == 8 && thread.get(2).contains("SocketChannelImpl.accept");
        }
        if (threadName.startsWith("P2P message reader")) {
            return stackSize <= 14 && (thread.getFirstFrame().contains("FileDispatcherImpl.read") || thread.getFirstFrame().contains("FileDispatcher.read") || thread.getFirstFrame().contains("SocketDispatcher.read"));
        }
        if (threadName.startsWith("PartitionedRegion Message Processor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Pooled Message Processor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Pooled High Priority Message Processor")) {
            return this.isIdleExecutor(thread) || thread.get(4).contains("OSProcess.zipStacks");
        }
        if (threadName.startsWith("Pooled Serial Message Processor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Pooled Waiting Message Processor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("ServerConnection")) {
            if (thread.getFirstFrame().contains("socketRead") && stackSize > 6 && thread.get(6).contains("fetchHeader")) {
                return true;
            }
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("TCP Check ServerSocket Thread")) {
            return stackSize >= 3 && thread.get(2).contains("socketAccept");
        }
        if (threadName.startsWith("Timer runner")) {
            return stackSize <= 10 && thread.get(1).contains("TIMED_WAITING");
        }
        if (threadName.startsWith("TransferQueueBundler")) {
            return stackSize == 9 && thread.get(2).contains("sun.misc.Unsafe.park");
        }
        if (threadName.startsWith("unicast receiver")) {
            return stackSize > 2 && thread.get(2).contains("PlainDatagramSocketImpl.receive");
        }
        if (threadName.startsWith("Asynchronous disk writer")) {
            return !thread.isRunnable() && stackSize <= 10 && stackSize >= 7 && (thread.get(5).contains("waitUntilFlushIsReady") || thread.get(6).contains("waitUntilFlushIsReady"));
        }
        if (threadName.startsWith("BridgeServer-LoadPollingThread")) {
            return !thread.isRunnable() && stackSize == 5;
        }
        if (threadName.startsWith("Cache Server Acceptor")) {
            return thread.getFirstFrame().contains("socketAccept");
        }
        if (threadName.startsWith("Client Message Dispatcher")) {
            return stackSize == 11 && thread.getFirstFrame().contains("socketWrite") || stackSize == 14 && thread.getFirstFrame().contains("Unsafe.park");
        }
        if (threadName.equals("ClientHealthMonitor Thread")) {
            return !thread.isRunnable() && stackSize == 4;
        }
        if (threadName.startsWith("Distribution Locator on")) {
            return stackSize <= 9 && thread.getFirstFrame().contains("socketAccept");
        }
        if (threadName.startsWith("DM-MemberEventInvoker")) {
            return !thread.isRunnable() && stackSize == 9 && thread.get(6).contains("Queue.take");
        }
        if (threadName.startsWith("Event Processor for GatewaySender")) {
            return !thread.isRunnable() && thread.get(3).contains("ConcurrentParallelGatewaySenderQueue.peek");
        }
        if (threadName.startsWith("GC Daemon")) {
            return !thread.isRunnable() && stackSize <= 6;
        }
        if (threadName.startsWith("Replicate/Partition Region Garbage Collector")) {
            return !thread.isRunnable() && stackSize <= 7;
        }
        if (threadName.startsWith("Non-replicate Region Garbage Collector")) {
            return !thread.isRunnable() && stackSize <= 7;
        }
        if (threadName.equals("GemFire Time Service")) {
            return !thread.isRunnable();
        }
        if (threadName.startsWith("GlobalTXTimeoutMonitor")) {
            return !thread.isRunnable() && stackSize <= 8 && thread.getFirstFrame().contains("Object.wait");
        }
        if (threadName.startsWith("JoinProcessor")) {
            return !thread.isRunnable() && stackSize <= 7;
        }
        if (threadName.startsWith("locator request thread")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Lock Grantor for")) {
            return !thread.isRunnable() && stackSize <= 8;
        }
        if (threadName.startsWith("Management Task")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("osprocess reaper")) {
            return stackSize == 5;
        }
        if (threadName.startsWith("P2P-Handshaker")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("P2P Listener")) {
            return stackSize == 7 && thread.getFirstFrame().contains("accept0");
        }
        if (threadName.startsWith("Queue Removal Thread")) {
            return !thread.isRunnable() && stackSize == 5 && thread.getFirstFrame().contains("Object.wait");
        }
        if (threadName.startsWith("ResourceManagerRecoveryThread")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("RMI TCP Connection(idle)")) {
            return true;
        }
        if (threadName.startsWith("RMI Reaper")) {
            return true;
        }
        if (threadName.startsWith("RMI RenewClean")) {
            return true;
        }
        if (threadName.startsWith("RMI Scheduler")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("RMI TCP Accept")) {
            return true;
        }
        if (threadName.startsWith("RMI TCP Connection")) {
            return thread.getFirstFrame().contains("socketRead0");
        }
        if (threadName.startsWith("SnapshotResultDispatcher")) {
            return !thread.isRunnable() && stackSize <= 8;
        }
        if (threadName.startsWith("StatMonitorNotifier Thread")) {
            return stackSize > 8 && thread.get(7).contains("SynchronousQueue.take");
        }
        if (threadName.startsWith("SystemFailure Proctor")) {
            return !thread.isRunnable() && stackSize == 6 && thread.getFirstFrame().contains("Thread.sleep");
        }
        if (threadName.startsWith("SystemFailure WatchDog")) {
            return stackSize <= 8 && thread.getFirstFrame().contains("Object.wait");
        }
        if (threadName.startsWith("ThresholdEventProcessor")) {
            return this.isIdleExecutor(thread);
        }
        if (threadName.startsWith("Timer-")) {
            if (thread.isRunnable()) {
                return true;
            }
            if (stackSize <= 8 && thread.getFirstFrame().contains("Object.wait")) {
                return true;
            }
        }
        if (threadName.startsWith("TimeScheduler.Thread")) {
            return !thread.isRunnable() && stackSize <= 8 && thread.getFirstFrame().contains("Object.wait");
        }
        if (threadName.startsWith("vfabric-license-heartbeat")) {
            if (thread.isRunnable()) {
                return false;
            }
            if (stackSize == 6 && thread.getFirstFrame().contains("Thread.sleep")) {
                return true;
            }
            return stackSize <= 7 && thread.getFirstFrame().contains("Object.wait");
        }
        if (threadName.equals("WAN Locator Discovery Thread")) {
            return !thread.isRunnable() && thread.get(3).contains("exchangeRemoteLocators");
        }
        return this.isIdleExecutor(thread);
    }

    boolean isIdleExecutor(ThreadStack thread) {
        if (thread.isRunnable()) {
            return false;
        }
        int size = thread.size();
        if (size > 8 && thread.get(7).contains("DMStats.take")) {
            return true;
        }
        if (size > 3 && thread.get(size - 3).contains("getTask")) {
            return true;
        }
        if (size > 4 && thread.get(size - 4).contains("getTask")) {
            return true;
        }
        if (size > 5 && thread.get(size - 5).contains("getTask")) {
            return true;
        }
        if (size > 6 && thread.get(size - 6).contains("getTask")) {
            return true;
        }
        return size > 7 && thread.get(size - 7).contains("getTask");
    }

    public static class ThreadStack
    implements Comparable {
        List<String> lines = new ArrayList<String>(20);
        boolean runnable;
        List<String> breadcrumbs;

        ThreadStack(String firstLine, String secondLine, String thirdLine, BufferedReader reader) throws IOException {
            this.lines.add(firstLine);
            this.lines.add(secondLine);
            this.runnable = secondLine.contains("RUNNABLE");
            this.lines.add(thirdLine);
            String line = null;
            while (true) {
                reader.mark(100000);
                line = reader.readLine();
                if (line == null || line.trim().length() == 0) break;
                if (line.startsWith("\"")) {
                    reader.reset();
                    break;
                }
                this.lines.add(line);
            }
        }

        void addBreadcrumbs(List crumbs) {
            this.breadcrumbs = new ArrayList<String>(crumbs);
        }

        void add(String line) {
            this.lines.add(line);
        }

        String get(int position) {
            return this.lines.get(position);
        }

        boolean isRunnable() {
            return this.runnable;
        }

        boolean contains(String subString) {
            for (int i = this.lines.size() - 1; i >= 0; --i) {
                if (!this.lines.get(i).contains(subString)) continue;
                return true;
            }
            return false;
        }

        String getFirstFrame() {
            if (this.lines.size() > 2) {
                return this.lines.get(2);
            }
            return "";
        }

        String getThreadName() {
            String firstLine = this.lines.get(0);
            int quote = firstLine.indexOf(34, 1);
            if (quote > 1) {
                return firstLine.substring(1, quote);
            }
            return firstLine.substring(1, firstLine.length());
        }

        int size() {
            return this.lines.size();
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            boolean first = true;
            for (String line : this.lines) {
                sw.append(line).append("\n");
                if (first && this.breadcrumbs != null) {
                    for (String bline : this.breadcrumbs) {
                        sw.append(bline).append("\n");
                    }
                }
                first = false;
            }
            return sw.toString();
        }

        public void writeTo(Writer w) throws IOException {
            if (DEBUG) {
                w.append("stack.name='" + this.getThreadName() + "' runnable=" + this.runnable + " lines=" + this.lines.size());
                w.append("\n");
            }
            boolean first = true;
            for (String line : this.lines) {
                w.append(line);
                w.append("\n");
                if (!first) continue;
                first = false;
                if (this.breadcrumbs == null) continue;
                for (String bline : this.breadcrumbs) {
                    w.append(bline).append("\n");
                }
            }
        }

        public void appendToBuffer(StringBuffer buffer) {
            if (DEBUG) {
                buffer.append("stack.name='" + this.getThreadName() + "' runnable=" + this.runnable + " lines=" + this.lines.size()).append("\n");
            }
            boolean first = true;
            for (String line : this.lines) {
                buffer.append(line).append("\n");
                if (first && this.breadcrumbs != null) {
                    for (String bline : this.breadcrumbs) {
                        buffer.append(bline).append("\n");
                    }
                }
                first = false;
            }
        }

        public int compareTo(Object other) {
            return ((ThreadStack)other).getThreadName().compareTo(this.getThreadName());
        }
    }
}

