/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DiskStoreMXBean;
import org.apache.geode.management.DistributedLockServiceMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.ManagementConstants;

public class MBeanJMXAdapter
implements ManagementConstants {
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private Map<ObjectName, Object> localGemFireMBean = new ConcurrentHashMap<ObjectName, Object>();
    private DistributedMember distMember = InternalDistributedSystem.getConnectedInstance().getDistributedMember();

    public ObjectName registerMBean(Object object, ObjectName objectName, boolean isGemFireMBean) {
        ObjectName newObjectName = objectName;
        try {
            if (!isGemFireMBean) {
                String member = MBeanJMXAdapter.getMemberNameOrId(this.distMember);
                String objectKeyProperty = objectName.getKeyPropertyListString();
                newObjectName = ObjectName.getInstance("GemFire:" + objectKeyProperty + "," + "member=" + member);
            }
            mbeanServer.registerMBean(object, newObjectName);
            this.localGemFireMBean.put(newObjectName, object);
        }
        catch (NullPointerException | InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new ManagementException(e);
        }
        return newObjectName;
    }

    public boolean hasNotificationSupport(ObjectName objectName) {
        try {
            Type[] intfTyps;
            if (!this.isRegistered(objectName)) {
                return false;
            }
            ObjectInstance instance = mbeanServer.getObjectInstance(objectName);
            String className = instance.getClassName();
            Class cls = ClassLoadUtil.classFromName(className);
            for (Type intfTyp1 : intfTyps = cls.getGenericInterfaces()) {
                Class intfTyp = (Class)intfTyp1;
                if (!intfTyp.equals(NotificationEmitter.class)) continue;
                return true;
            }
            Class superClassType = (Class)cls.getGenericSuperclass();
            if (superClassType != null && superClassType.equals(NotificationBroadcasterSupport.class)) {
                return true;
            }
        }
        catch (ClassNotFoundException | InstanceNotFoundException e) {
            throw new ManagementException(e);
        }
        return false;
    }

    public void registerMBeanProxy(Object object, ObjectName objectName) {
        try {
            mbeanServer.registerMBean(object, objectName);
        }
        catch (NullPointerException | InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new ManagementException(e);
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        try {
            if (!this.isRegistered(objectName)) {
                return;
            }
            mbeanServer.unregisterMBean(objectName);
            if (this.localGemFireMBean.get(objectName) != null) {
                this.localGemFireMBean.remove(objectName);
            }
        }
        catch (NullPointerException | InstanceNotFoundException | MBeanRegistrationException e) {
            throw new ManagementException(e);
        }
    }

    public Object getMBeanObject(ObjectName objectName) {
        return this.localGemFireMBean.get(objectName);
    }

    public <T> T findMBeanByName(ObjectName objectName, Class<T> interfaceClass) {
        Object mbeanInstance = this.localGemFireMBean.get(objectName);
        if (mbeanInstance != null) {
            return interfaceClass.cast(mbeanInstance);
        }
        return null;
    }

    public boolean isLocalMBean(ObjectName objectName) {
        return this.localGemFireMBean.containsKey(objectName);
    }

    public void unregisterAll() {
        try {
            ObjectName name = new ObjectName("GemFire:*");
            Set<ObjectName> gemFireObjects = mbeanServer.queryNames(name, null);
            for (ObjectName objectName : gemFireObjects) {
                this.unregisterMBean(objectName);
            }
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
    }

    public void cleanJMXResource() {
        this.localGemFireMBean.clear();
        this.unregisterAll();
    }

    public boolean isRegistered(ObjectName objectName) {
        return mbeanServer.isRegistered(objectName);
    }

    public static String getMemberNameOrId(DistributedMember member) {
        if (member.getName() != null && !member.getName().equals("")) {
            return MBeanJMXAdapter.makeCompliantName(member.getName());
        }
        return MBeanJMXAdapter.makeCompliantName(member.getId());
    }

    public static String makeCompliantName(String value) {
        value = value.replace(':', '-');
        value = value.replace(',', '-');
        value = value.replace('=', '-');
        value = value.replace('*', '-');
        if ((value = value.replace('?', '-')).length() < 1) {
            value = "nothing";
        }
        return value;
    }

    public static String makeCompliantRegionPath(String value) {
        if (MBeanJMXAdapter.isQuoted(value)) {
            value = ObjectName.unquote(value);
        } else if (MBeanJMXAdapter.containsSpecialChar(value)) {
            value = ObjectName.quote(value);
        }
        return value;
    }

    private static boolean containsSpecialChar(String value) {
        return value.contains(":") || value.contains("@") || value.contains("-") || value.contains("#") || value.contains("+") || value.contains("?");
    }

    private static boolean isQuoted(String value) {
        int len = value.length();
        return len >= 2 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"';
    }

    public static String makeCompliantRegionNameAppender(String value) {
        return value.replace("/", "-").replace(":", "");
    }

    public MemberMXBean getMemberMXBean() {
        ObjectName objName = MBeanJMXAdapter.getMemberMBeanName(this.distMember);
        return (MemberMXBean)this.localGemFireMBean.get(objName);
    }

    public RegionMXBean getLocalRegionMXBean(String regionPath) {
        ObjectName objName = MBeanJMXAdapter.getRegionMBeanName(this.distMember, regionPath);
        return (RegionMXBean)this.localGemFireMBean.get(objName);
    }

    public LockServiceMXBean getLocalLockServiceMXBean(String lockServiceName) {
        ObjectName objName = MBeanJMXAdapter.getLockServiceMBeanName(this.distMember, lockServiceName);
        return (LockServiceMXBean)this.localGemFireMBean.get(objName);
    }

    public DiskStoreMXBean getLocalDiskStoreMXBean(String disStoreName) {
        ObjectName objName = MBeanJMXAdapter.getDiskStoreMBeanName(this.distMember, disStoreName);
        return (DiskStoreMXBean)this.localGemFireMBean.get(objName);
    }

    public CacheServerMXBean getClientServiceMXBean(int serverPort) {
        ObjectName objName = MBeanJMXAdapter.getClientServiceMBeanName(serverPort, this.distMember);
        return (CacheServerMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedLockServiceMXBean getDistributedLockServiceMXBean(String lockServiceName) {
        ObjectName objName = MBeanJMXAdapter.getDistributedLockServiceName(lockServiceName);
        return (DistributedLockServiceMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedRegionMXBean getDistributedRegionMXBean(String regionPath) {
        ObjectName objName = MBeanJMXAdapter.getDistributedRegionMbeanName(regionPath);
        return (DistributedRegionMXBean)this.localGemFireMBean.get(objName);
    }

    public ManagerMXBean getManagerMXBean() {
        ObjectName objName = MBeanJMXAdapter.getManagerName();
        return (ManagerMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedSystemMXBean getDistributedSystemMXBean() {
        ObjectName objName = MBeanJMXAdapter.getDistributedSystemName();
        return (DistributedSystemMXBean)this.localGemFireMBean.get(objName);
    }

    public GatewayReceiverMXBean getGatewayReceiverMXBean() {
        ObjectName objName = MBeanJMXAdapter.getGatewayReceiverMBeanName(this.distMember);
        return (GatewayReceiverMXBean)this.localGemFireMBean.get(objName);
    }

    public GatewaySenderMXBean getGatewaySenderMXBean(String senderId) {
        ObjectName objName = MBeanJMXAdapter.getGatewaySenderMBeanName(this.distMember, senderId);
        return (GatewaySenderMXBean)this.localGemFireMBean.get(objName);
    }

    public AsyncEventQueueMXBean getAsyncEventQueueMXBean(String queueId) {
        ObjectName objName = MBeanJMXAdapter.getAsyncEventQueueMBeanName(this.distMember, queueId);
        return (AsyncEventQueueMXBean)this.localGemFireMBean.get(objName);
    }

    public LocatorMXBean getLocatorMXBean() {
        ObjectName objName = MBeanJMXAdapter.getLocatorMBeanName(this.distMember);
        return (LocatorMXBean)this.localGemFireMBean.get(objName);
    }

    public static ObjectName getObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
    }

    public static ObjectName getMemberMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getMemberMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getRegionMBeanName(DistributedMember member, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getRegionMBeanName(String member, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getRegionMBeanName(ObjectName memberMBeanName, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), memberMBeanName.getKeyProperty("member")));
    }

    public static ObjectName getDiskStoreMBeanName(DistributedMember member, String diskName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=DiskStore,name={0},type=Member,member={1}", diskName, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getDiskStoreMBeanName(String member, String diskName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=DiskStore,name={0},type=Member,member={1}", diskName, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getClientServiceMBeanName(int serverPort, DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=CacheServer,port={0},type=Member,member={1}", String.valueOf(serverPort), MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getClientServiceMBeanName(int serverPort, String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=CacheServer,port={0},type=Member,member={1}", String.valueOf(serverPort), MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getLockServiceMBeanName(DistributedMember member, String lockServiceName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Member,member={1}", lockServiceName, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getLockServiceMBeanName(String member, String lockServiceName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Member,member={1}", lockServiceName, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getGatewayReceiverMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewayReceiver,type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getGatewayReceiverMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewayReceiver,type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getGatewaySenderMBeanName(DistributedMember member, String id) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewaySender,gatewaySender={0},type=Member,member={1}", id, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getGatewaySenderMBeanName(String member, String id) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewaySender,gatewaySender={0},type=Member,member={1}", id, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getAsyncEventQueueMBeanName(DistributedMember member, String queueId) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=AsyncEventQueue,queue={0},type=Member,member={1}", queueId, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getDistributedRegionMbeanName(String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Distributed", MBeanJMXAdapter.makeCompliantRegionPath(regionPath)));
    }

    public static ObjectName getDistributedRegionMbeanNameInternal(String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Distributed", regionPath));
    }

    public static ObjectName getDistributedLockServiceName(String lockService) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Distributed", lockService));
    }

    public static ObjectName getDistributedSystemName() {
        return MBeanJMXAdapter.getObjectName("GemFire:service=System,type=Distributed");
    }

    public static ObjectName getManagerName() {
        String member = MBeanJMXAdapter.getMemberNameOrId(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Manager,type=Member,member={0}", member));
    }

    public static ObjectName getLocatorMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Locator,type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getLocatorMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Locator,type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getCacheServiceMBeanName(DistributedMember member, String cacheServiceId) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=CacheService,name={0},type=Member,member={1}", cacheServiceId, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public Map<ObjectName, Object> getLocalGemFireMBean() {
        return this.localGemFireMBean;
    }

    public static String getUniqueIDForMember(DistributedMember member) {
        InternalDistributedMember iMember = (InternalDistributedMember)member;
        StringBuilder sb = new StringBuilder();
        sb.append(iMember.getInetAddress().getHostAddress());
        sb.append("<v").append(iMember.getVmViewId()).append(">");
        sb.append(iMember.getPort());
        return MBeanJMXAdapter.makeCompliantName(sb.toString().toLowerCase());
    }

    public static boolean isAttributeAvailable(String attributeName, String objectName) {
        try {
            ObjectName objName = new ObjectName(objectName);
            mbeanServer.getAttribute(objName, attributeName);
        }
        catch (NullPointerException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            return false;
        }
        return true;
    }
}

