/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.AlreadyRunningException;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DiskStoreMXBean;
import org.apache.geode.management.DistributedLockServiceMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.BaseManagementService;
import org.apache.geode.management.internal.FederatingManager;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.LocalManager;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.ManagementFunction;
import org.apache.geode.management.internal.ManagementMembershipListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.NotificationHub;
import org.apache.geode.management.internal.ProxyListener;
import org.apache.geode.management.internal.beans.ManagementAdapter;
import org.apache.geode.management.membership.MembershipEvent;
import org.apache.geode.management.membership.MembershipListener;
import org.apache.logging.log4j.Logger;

public class SystemManagementService
extends BaseManagementService {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedSystem system;
    private LocalManager localManager;
    private NotificationHub notificationHub;
    private volatile boolean closed = false;
    private volatile boolean isStarted = false;
    private MBeanJMXAdapter jmxAdapter;
    private InternalCache cache;
    private FederatingManager federatingManager;
    private final ManagementAgent agent;
    private ManagementResourceRepo repo;
    private ManagementMembershipListener listener;
    private List<ProxyListener> proxyListeners;
    private UniversalListenerContainer universalListenerContainer = new UniversalListenerContainer();

    public static BaseManagementService newSystemManagementService(InternalCache cache) {
        return new SystemManagementService(cache).init();
    }

    protected SystemManagementService(InternalCache cache) {
        this.cache = cache;
        this.system = (InternalDistributedSystem)cache.getDistributedSystem();
        if (!this.system.isConnected()) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString());
        }
        this.jmxAdapter = new MBeanJMXAdapter();
        this.repo = new ManagementResourceRepo();
        this.notificationHub = new NotificationHub(this.repo);
        this.agent = this.system.getConfig().getJmxManager() ? new ManagementAgent(this.system.getConfig(), cache.getSecurityService()) : null;
        ManagementFunction function = new ManagementFunction(this.notificationHub);
        FunctionService.registerFunction(function);
        this.proxyListeners = new CopyOnWriteArrayList<ProxyListener>();
    }

    private SystemManagementService init() {
        try {
            this.localManager = new LocalManager(this.repo, this.system, this, this.cache);
            this.localManager.startManager();
            this.listener = new ManagementMembershipListener(this);
            this.system.getDistributionManager().addMembershipListener(this.listener);
            this.isStarted = true;
            return this;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ManagementException(e);
        }
    }

    public LocalManager getLocalManager() {
        return this.localManager;
    }

    public NotificationHub getNotificationHub() {
        return this.notificationHub;
    }

    public FederatingManager getFederatingManager() {
        return this.federatingManager;
    }

    public MBeanJMXAdapter getJMXAdapter() {
        return this.jmxAdapter;
    }

    public ManagementAgent getManagementAgent() {
        return this.agent;
    }

    public boolean isStartedAndOpen() {
        return this.isStarted && !this.closed && this.system.isConnected();
    }

    private void verifyManagementService() {
        if (!this.isStarted) {
            throw new ManagementException(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_NOT_STARTED_YET.toLocalizedString());
        }
        if (!this.system.isConnected()) {
            throw new ManagementException(ManagementStrings.Management_Service_NOT_CONNECTED_TO_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        if (this.closed) {
            throw new ManagementException(ManagementStrings.Management_Service_MANAGEMENT_SERVICE_IS_CLOSED.toLocalizedString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map map = instances;
        synchronized (map) {
            if (this.closed) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Closing Management Service");
            }
            if (this.listener != null && this.system.isConnected()) {
                this.system.getDistributionManager().removeMembershipListener(this.listener);
            }
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                this.federatingManager.stopManager();
            }
            this.notificationHub.cleanUpListeners();
            this.jmxAdapter.cleanJMXResource();
            if (this.localManager.isRunning()) {
                this.localManager.stopManager();
            }
            if (this.agent != null && this.agent.isRunning()) {
                this.agent.stopAgent();
            }
            this.getInternalCache().getJmxManagerAdvisor().broadcastChange();
            instances.remove(this.cache);
            this.localManager = null;
            this.closed = true;
        }
    }

    @Override
    public <T> void federate(ObjectName objectName, Class<T> interfaceClass, boolean notificationEmitter) {
        this.verifyManagementService();
        if (!objectName.getDomain().equalsIgnoreCase("GemFire")) {
            throw new ManagementException(ManagementStrings.Management_Service_NOT_A_GEMFIRE_DOMAIN_MBEAN.toLocalizedString());
        }
        if (!this.jmxAdapter.isRegistered(objectName)) {
            throw new ManagementException(ManagementStrings.Management_Service_MBEAN_NOT_REGISTERED_IN_GEMFIRE_DOMAIN.toLocalizedString());
        }
        if (notificationEmitter && !this.jmxAdapter.hasNotificationSupport(objectName)) {
            throw new ManagementException(ManagementStrings.Management_Service_MBEAN_DOES_NOT_HAVE_NOTIFICATION_SUPPORT.toLocalizedString());
        }
        Object object = this.jmxAdapter.getMBeanObject(objectName);
        FederationComponent fedComp = new FederationComponent(object, objectName, interfaceClass, notificationEmitter);
        if (ManagementAdapter.refreshOnInit.contains(interfaceClass)) {
            fedComp.refreshObjectState(true);
        }
        this.localManager.markForFederation(objectName, fedComp);
        if (this.isManager()) {
            this.afterCreateProxy(objectName, interfaceClass, object, fedComp);
        }
    }

    @Override
    public CacheServerMXBean getLocalCacheServerMXBean(int serverPort) {
        return this.jmxAdapter.getClientServiceMXBean(serverPort);
    }

    @Override
    public long getLastUpdateTime(ObjectName objectName) {
        if (!this.isStartedAndOpen()) {
            return 0L;
        }
        if (this.federatingManager == null) {
            return 0L;
        }
        if (!this.federatingManager.isRunning()) {
            return 0L;
        }
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return 0L;
        }
        return this.federatingManager.getLastUpdateTime(objectName);
    }

    @Override
    public DiskStoreMXBean getLocalDiskStoreMBean(String diskStoreName) {
        return this.jmxAdapter.getLocalDiskStoreMXBean(diskStoreName);
    }

    @Override
    public LockServiceMXBean getLocalLockServiceMBean(String lockServiceName) {
        return this.jmxAdapter.getLocalLockServiceMXBean(lockServiceName);
    }

    @Override
    public RegionMXBean getLocalRegionMBean(String regionPath) {
        return this.jmxAdapter.getLocalRegionMXBean(regionPath);
    }

    public <T> T getMBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        if (!this.isStartedAndOpen()) {
            return null;
        }
        if (this.federatingManager == null) {
            return null;
        }
        if (!this.federatingManager.isRunning()) {
            return null;
        }
        return this.federatingManager.findProxy(objectName, interfaceClass);
    }

    @Override
    public MemberMXBean getMemberMXBean() {
        return this.jmxAdapter.getMemberMXBean();
    }

    @Override
    public Set<ObjectName> queryMBeanNames(DistributedMember member) {
        if (!this.isStartedAndOpen()) {
            return Collections.emptySet();
        }
        if (this.cache.getDistributedSystem().getDistributedMember().equals(member)) {
            return this.jmxAdapter.getLocalGemFireMBean().keySet();
        }
        if (this.federatingManager == null) {
            return Collections.emptySet();
        }
        if (!this.federatingManager.isRunning()) {
            return Collections.emptySet();
        }
        return this.federatingManager.findAllProxies(member);
    }

    @Override
    public Set<ObjectName> getAsyncEventQueueMBeanNames(DistributedMember member) {
        Set<ObjectName> mBeanNames = this.queryMBeanNames(member);
        return mBeanNames.stream().filter(x -> "AsyncEventQueue".equals(x.getKeyProperty("service"))).collect(Collectors.toSet());
    }

    @Override
    public ObjectName registerMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        return this.jmxAdapter.registerMBean(object, objectName, false);
    }

    public ObjectName registerInternalMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        return this.jmxAdapter.registerMBean(object, objectName, true);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) {
        FederationComponent removedObj;
        if (!this.isStartedAndOpen()) {
            return;
        }
        this.verifyManagementService();
        if (this.isManager() && (removedObj = this.localManager.getFedComponents().get(objectName)) != null) {
            this.afterRemoveProxy(objectName, removedObj.getInterfaceClass(), removedObj.getMBeanObject(), removedObj);
        }
        this.jmxAdapter.unregisterMBean(objectName);
        this.localManager.unMarkForFederation(objectName);
    }

    @Override
    public boolean isManager() {
        return this.isManagerCreated() && this.federatingManager.isRunning();
    }

    public boolean isManagerCreated() {
        return this.isStartedAndOpen() && this.federatingManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startManager() {
        if (!this.getInternalCache().getInternalDistributedSystem().getConfig().getJmxManager()) {
            throw new ManagementException("Could not start the manager because the gemfire property \"jmx-manager\" is false.");
        }
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                throw new AlreadyRunningException(ManagementStrings.Management_Service_MANAGER_ALREADY_RUNNING.toLocalizedString());
            }
            boolean needsToBeStarted = false;
            if (!this.isManagerCreated()) {
                this.createManager();
                needsToBeStarted = true;
            } else if (!this.federatingManager.isRunning()) {
                needsToBeStarted = true;
            }
            if (needsToBeStarted) {
                boolean started = false;
                try {
                    this.system.handleResourceEvent(ResourceEvent.MANAGER_START, null);
                    this.federatingManager.startManager();
                    if (this.agent != null) {
                        this.agent.startAgent(this.getInternalCache());
                    }
                    this.getInternalCache().getJmxManagerAdvisor().broadcastChange();
                    started = true;
                }
                catch (Error | RuntimeException e) {
                    logger.error("Jmx manager could not be started because {}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
                finally {
                    if (!started) {
                        if (this.federatingManager != null) {
                            this.federatingManager.stopManager();
                        }
                        this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                    }
                }
            }
        }
    }

    private InternalCache getInternalCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createManager() {
        Map map = instances;
        synchronized (map) {
            if (this.federatingManager != null) {
                return false;
            }
            this.system.handleResourceEvent(ResourceEvent.MANAGER_CREATE, null);
            this.federatingManager = new FederatingManager(this.jmxAdapter, this.repo, this.system, this, this.cache);
            this.getInternalCache().getJmxManagerAdvisor().broadcastChange();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopManager() {
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null) {
                this.federatingManager.stopManager();
                this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                this.getInternalCache().getJmxManagerAdvisor().broadcastChange();
                if (this.agent != null && (this.agent.isRunning() || this.agent.isHttpServiceRunning())) {
                    this.agent.stopAgent();
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DistributedLockServiceMXBean getDistributedLockServiceMXBean(String lockServiceName) {
        return this.jmxAdapter.getDistributedLockServiceMXBean(lockServiceName);
    }

    @Override
    public DistributedRegionMXBean getDistributedRegionMXBean(String regionName) {
        return this.jmxAdapter.getDistributedRegionMXBean(regionName);
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        return this.jmxAdapter.getDistributedSystemMXBean();
    }

    public void addProxyListener(ProxyListener listener) {
        this.proxyListeners.add(listener);
    }

    public void removeProxyListener(ProxyListener listener) {
        this.proxyListeners.remove(listener);
    }

    public List<ProxyListener> getProxyListeners() {
        return this.proxyListeners;
    }

    @Override
    public ManagerMXBean getManagerMXBean() {
        return this.jmxAdapter.getManagerMXBean();
    }

    @Override
    public ObjectName getCacheServerMBeanName(int serverPort, DistributedMember member) {
        return MBeanJMXAdapter.getClientServiceMBeanName(serverPort, member);
    }

    @Override
    public ObjectName getDiskStoreMBeanName(DistributedMember member, String diskName) {
        return MBeanJMXAdapter.getDiskStoreMBeanName(member, diskName);
    }

    @Override
    public ObjectName getDistributedLockServiceMBeanName(String lockService) {
        return MBeanJMXAdapter.getDistributedLockServiceName(lockService);
    }

    @Override
    public ObjectName getDistributedRegionMBeanName(String regionPath) {
        return MBeanJMXAdapter.getDistributedRegionMbeanName(regionPath);
    }

    @Override
    public ObjectName getDistributedSystemMBeanName() {
        return MBeanJMXAdapter.getDistributedSystemName();
    }

    @Override
    public ObjectName getGatewayReceiverMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
    }

    @Override
    public ObjectName getGatewaySenderMBeanName(DistributedMember member, String gatewaySenderId) {
        return MBeanJMXAdapter.getGatewaySenderMBeanName(member, gatewaySenderId);
    }

    @Override
    public ObjectName getAsyncEventQueueMBeanName(DistributedMember member, String queueId) {
        return MBeanJMXAdapter.getAsyncEventQueueMBeanName(member, queueId);
    }

    @Override
    public ObjectName getLockServiceMBeanName(DistributedMember member, String lockServiceName) {
        return MBeanJMXAdapter.getLockServiceMBeanName(member, lockServiceName);
    }

    @Override
    public ObjectName getManagerMBeanName() {
        return MBeanJMXAdapter.getManagerName();
    }

    @Override
    public ObjectName getMemberMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getMemberMBeanName(member);
    }

    @Override
    public ObjectName getRegionMBeanName(DistributedMember member, String regionPath) {
        return MBeanJMXAdapter.getRegionMBeanName(member, regionPath);
    }

    @Override
    public GatewayReceiverMXBean getLocalGatewayReceiverMXBean() {
        return this.jmxAdapter.getGatewayReceiverMXBean();
    }

    @Override
    public GatewaySenderMXBean getLocalGatewaySenderMXBean(String senderId) {
        return this.jmxAdapter.getGatewaySenderMXBean(senderId);
    }

    @Override
    public AsyncEventQueueMXBean getLocalAsyncEventQueueMXBean(String queueId) {
        return this.jmxAdapter.getAsyncEventQueueMXBean(queueId);
    }

    @Override
    public ObjectName getLocatorMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getLocatorMBeanName(member);
    }

    @Override
    public LocatorMXBean getLocalLocatorMXBean() {
        return this.jmxAdapter.getLocatorMXBean();
    }

    public boolean afterCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
        return true;
    }

    public boolean afterPseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterPseudoCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
        return true;
    }

    public boolean afterRemoveProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterRemoveProxy(objectName, interfaceClass, proxyObject, oldVal);
        }
        return true;
    }

    public boolean afterUpdateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterUpdateProxy(objectName, interfaceClass, proxyObject, newVal, oldVal);
        }
        return true;
    }

    public void handleNotification(Notification notification) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.handleNotification(notification);
        }
    }

    @Override
    public <T> T getMBeanInstance(ObjectName objectName, Class<T> interfaceClass) {
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return this.jmxAdapter.findMBeanByName(objectName, interfaceClass);
        }
        return this.getMBeanProxy(objectName, interfaceClass);
    }

    public void logFine(String s) {
        if (logger.isDebugEnabled()) {
            logger.debug(s);
        }
    }

    public void memberJoined(InternalDistributedMember id) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberJoined(this.system.getDistributionManager(), id);
        }
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberDeparted(this.system.getDistributionManager(), id, crashed);
        }
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberSuspect(this.system.getDistributionManager(), id, whoSuspected, reason);
        }
    }

    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.quorumLost(this.system.getDistributionManager(), failures, remaining);
        }
    }

    public UniversalListenerContainer getUniversalListenerContainer() {
        return this.universalListenerContainer;
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.addMembershipListener(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.removeMembershipListener(listener);
    }

    public static class UniversalListenerContainer {
        private List<MembershipListener> membershipListeners = new CopyOnWriteArrayList<MembershipListener>();

        public void memberJoined(InternalDistributedMember id) {
            MembershipEvent event = this.createEvent(id);
            for (MembershipListener listener : this.membershipListeners) {
                try {
                    listener.memberJoined(event);
                }
                catch (Exception e) {
                    logger.error("Could not invoke listener event memberJoined for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                }
            }
        }

        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            MembershipEvent event = this.createEvent(id);
            if (!crashed) {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberLeft(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberLeft for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                    }
                }
            } else {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberCrashed(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberCrashed for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }

        private MembershipEvent createEvent(InternalDistributedMember id) {
            final String memberId = id.getId();
            final InternalDistributedMember member = id;
            return new MembershipEvent(){

                @Override
                public String getMemberId() {
                    return memberId;
                }

                @Override
                public DistributedMember getDistributedMember() {
                    return member;
                }
            };
        }

        public void addMembershipListener(MembershipListener listener) {
            this.membershipListeners.add(listener);
        }

        public void removeMembershipListener(MembershipListener listener) {
            this.membershipListeners.remove(listener);
        }
    }
}

