/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.AlertDetails;
import org.apache.geode.management.internal.beans.ManagementAdapter;

public class ManagementListener
implements ResourceEventsListener {
    private ManagementAdapter adapter = new ManagementAdapter();
    private LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();

    private boolean shouldProceed(ResourceEvent event) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system == null && !event.equals((Object)ResourceEvent.CACHE_REMOVE)) {
            return false;
        }
        GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
        if (currentCache == null) {
            return false;
        }
        return !currentCache.isClosed();
    }

    @Override
    public void handleEvent(ResourceEvent event, Object resource) {
        if (!this.shouldProceed(event)) {
            return;
        }
        switch (event) {
            case CACHE_CREATE: {
                InternalCache createdCache = (InternalCache)resource;
                this.adapter.handleCacheCreation(createdCache);
                break;
            }
            case CACHE_REMOVE: {
                InternalCache removedCache = (InternalCache)resource;
                this.adapter.handleCacheRemoval(removedCache);
                break;
            }
            case REGION_CREATE: {
                Region createdRegion = (Region)resource;
                this.adapter.handleRegionCreation(createdRegion);
                break;
            }
            case REGION_REMOVE: {
                Region removedRegion = (Region)resource;
                this.adapter.handleRegionRemoval(removedRegion);
                break;
            }
            case DISKSTORE_CREATE: {
                DiskStore createdDisk = (DiskStore)resource;
                this.adapter.handleDiskCreation(createdDisk);
                break;
            }
            case DISKSTORE_REMOVE: {
                DiskStore removedDisk = (DiskStore)resource;
                this.adapter.handleDiskRemoval(removedDisk);
                break;
            }
            case GATEWAYRECEIVER_CREATE: {
                GatewayReceiver createdRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverCreate(createdRecv);
                break;
            }
            case GATEWAYRECEIVER_DESTROY: {
                GatewayReceiver destroyedRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverDestroy(destroyedRecv);
                break;
            }
            case GATEWAYRECEIVER_START: {
                GatewayReceiver startedRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverStart(startedRecv);
                break;
            }
            case GATEWAYRECEIVER_STOP: {
                GatewayReceiver stoppededRecv = (GatewayReceiver)resource;
                this.adapter.handleGatewayReceiverStop(stoppededRecv);
                break;
            }
            case GATEWAYSENDER_CREATE: {
                GatewaySender sender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderCreation(sender);
                break;
            }
            case GATEWAYSENDER_START: {
                GatewaySender startedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderStart(startedSender);
                break;
            }
            case GATEWAYSENDER_STOP: {
                GatewaySender stoppedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderStop(stoppedSender);
                break;
            }
            case GATEWAYSENDER_PAUSE: {
                GatewaySender pausedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderPaused(pausedSender);
                break;
            }
            case GATEWAYSENDER_RESUME: {
                GatewaySender resumedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderResumed(resumedSender);
                break;
            }
            case GATEWAYSENDER_REMOVE: {
                GatewaySender removedSender = (GatewaySender)resource;
                this.adapter.handleGatewaySenderRemoved(removedSender);
                break;
            }
            case LOCKSERVICE_CREATE: {
                DLockService createdLockService = (DLockService)resource;
                this.adapter.handleLockServiceCreation(createdLockService);
                break;
            }
            case LOCKSERVICE_REMOVE: {
                DLockService removedLockService = (DLockService)resource;
                this.adapter.handleLockServiceRemoval(removedLockService);
                break;
            }
            case MANAGER_CREATE: {
                this.adapter.handleManagerCreation();
                break;
            }
            case MANAGER_START: {
                this.adapter.handleManagerStart();
                break;
            }
            case MANAGER_STOP: {
                this.adapter.handleManagerStop();
                break;
            }
            case ASYNCEVENTQUEUE_CREATE: {
                AsyncEventQueue queue = (AsyncEventQueue)resource;
                this.adapter.handleAsyncEventQueueCreation(queue);
                break;
            }
            case ASYNCEVENTQUEUE_REMOVE: {
                AsyncEventQueue removedQueue = (AsyncEventQueue)resource;
                this.adapter.handleAsyncEventQueueRemoval(removedQueue);
                break;
            }
            case SYSTEM_ALERT: {
                AlertDetails details = (AlertDetails)resource;
                this.adapter.handleSystemNotification(details);
                break;
            }
            case CACHE_SERVER_START: {
                CacheServer startedServer = (CacheServer)resource;
                this.adapter.handleCacheServerStart(startedServer);
                break;
            }
            case CACHE_SERVER_STOP: {
                CacheServer stoppedServer = (CacheServer)resource;
                this.adapter.handleCacheServerStop(stoppedServer);
                break;
            }
            case LOCATOR_START: {
                Locator loc = (Locator)resource;
                this.adapter.handleLocatorStart(loc);
                break;
            }
            case CACHE_SERVICE_CREATE: {
                CacheService service = (CacheService)resource;
                this.adapter.handleCacheServiceCreation(service);
                break;
            }
        }
    }
}

