/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class GatewaySenderOverflowMonitor
extends MBeanStatsMonitor {
    private volatile long entriesOverflowedToDisk = 0L;
    private volatile long bytesOverflowedToDisk = 0L;
    private volatile long lruEvictions = 0L;
    private Map<Statistics, ValueMonitor> monitors = new HashMap<Statistics, ValueMonitor>();
    private Map<Statistics, StatisticsListener> listeners = new HashMap<Statistics, StatisticsListener>();

    public GatewaySenderOverflowMonitor(String name) {
        super(name);
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        ValueMonitor overflowMonitor = new ValueMonitor();
        GatewaySenderOverflowStatisticsListener listener = new GatewaySenderOverflowStatisticsListener();
        overflowMonitor.addListener(listener);
        overflowMonitor.addStatistics(stats);
        this.monitors.put(stats, overflowMonitor);
        this.listeners.put(stats, listener);
    }

    @Override
    public void removeStatisticsFromMonitor(Statistics stats) {
    }

    @Override
    public void stopListener() {
        for (Statistics stat : this.listeners.keySet()) {
            ValueMonitor monitor = this.monitors.get(stat);
            monitor.removeListener(this.listeners.get(stat));
            monitor.removeStatistics(stat);
        }
        this.listeners.clear();
        this.monitors.clear();
    }

    @Override
    public Number getStatistic(String name) {
        if (name.equals("lruEvictions")) {
            return this.getLruEvictions();
        }
        if (name.equals("entriesOnlyOnDisk")) {
            return this.getEntriesOverflowedToDisk();
        }
        if (name.equals("bytesOnlyOnDisk")) {
            return this.getBytesOverflowedToDisk();
        }
        return 0;
    }

    private Number computeDelta(MBeanStatsMonitor.DefaultHashMap statsMap, String name, Number currentValue) {
        if (name.equals("lruEvictions")) {
            Long prevValue = statsMap.get("lruEvictions").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("entriesOnlyOnDisk")) {
            Long prevValue = statsMap.get("entriesOnlyOnDisk").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("bytesOnlyOnDisk")) {
            Long prevValue = statsMap.get("bytesOnlyOnDisk").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        return 0;
    }

    private void increaseStats(String name, Number value) {
        if (name.equals("lruEvictions")) {
            this.lruEvictions += value.longValue();
            return;
        }
        if (name.equals("entriesOnlyOnDisk")) {
            this.entriesOverflowedToDisk += value.longValue();
            return;
        }
        if (name.equals("bytesOnlyOnDisk")) {
            this.bytesOverflowedToDisk += value.longValue();
            return;
        }
    }

    public long getLruEvictions() {
        return this.lruEvictions;
    }

    public long getEntriesOverflowedToDisk() {
        return this.entriesOverflowedToDisk;
    }

    public long getBytesOverflowedToDisk() {
        return this.bytesOverflowedToDisk;
    }

    private class GatewaySenderOverflowStatisticsListener
    implements StatisticsListener {
        MBeanStatsMonitor.DefaultHashMap statsMap = new MBeanStatsMonitor.DefaultHashMap();

        private GatewaySenderOverflowStatisticsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(StatisticsNotification notification) {
            MBeanStatsMonitor.DefaultHashMap defaultHashMap = this.statsMap;
            synchronized (defaultHashMap) {
                for (StatisticId statId : notification) {
                    Number value;
                    StatisticDescriptor descriptor = statId.getStatisticDescriptor();
                    String name = descriptor.getName();
                    try {
                        value = notification.getValue(statId);
                    }
                    catch (StatisticNotFoundException e) {
                        value = 0;
                    }
                    GatewaySenderOverflowMonitor.this.log(name, value);
                    Number deltaValue = GatewaySenderOverflowMonitor.this.computeDelta(this.statsMap, name, value);
                    this.statsMap.put(name, value);
                    GatewaySenderOverflowMonitor.this.increaseStats(name, deltaValue);
                }
            }
        }
    }
}

