/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.management.internal.FederationComponent;

public class StatsAggregator {
    private Map<String, Class<?>> typeMap;
    private Map<String, AtomicReference<Number>> aggregateMap;
    private LogWriterI18n logger;

    public StatsAggregator(Map<String, Class<?>> typeMap) {
        this.typeMap = typeMap;
        this.aggregateMap = new HashMap<String, AtomicReference<Number>>();
        this.logger = InternalDistributedSystem.getLoggerI18n();
        this.initAggregateMap();
    }

    private void initAggregateMap() {
        Iterator<String> it = this.typeMap.keySet().iterator();
        while (it.hasNext()) {
            AtomicReference<Number> ref = null;
            String attribute = it.next();
            Class<?> classzz = this.typeMap.get(attribute);
            if (classzz == Long.TYPE) {
                ref = new AtomicReference<Long>(new Long(0L));
            } else if (classzz == Integer.TYPE) {
                ref = new AtomicReference<Integer>(new Integer(0));
            } else if (classzz == Float.TYPE) {
                ref = new AtomicReference<Float>(new Float(0.0f));
            } else if (classzz == Double.TYPE) {
                ref = new AtomicReference<Double>(new Double(0.0));
            }
            this.aggregateMap.put(attribute, ref);
        }
    }

    public void aggregate(FederationComponent newComp, FederationComponent oldComp) {
        block16: {
            Map<String, Object> newState;
            Map<String, Object> map = newState = newComp != null ? newComp.getObjectState() : null;
            Map<String, Object> oldState = oldComp != null && oldComp.getOldState().size() > 0 ? oldComp.getOldState() : (oldComp != null ? oldComp.getObjectState() : null);
            String attribute = null;
            try {
                if (this.typeMap != null && !this.typeMap.isEmpty()) {
                    for (Map.Entry<String, Class<?>> typeEntry : this.typeMap.entrySet()) {
                        Class<?> classzz;
                        Object oldVal;
                        Object newVal;
                        attribute = typeEntry.getKey();
                        Object object = newVal = newState != null ? newState.get(attribute) : null;
                        if (newVal != null) {
                            oldVal = null;
                            if (oldState != null) {
                                oldVal = oldState.get(attribute);
                            }
                            if ((classzz = typeEntry.getValue()) == Long.TYPE) {
                                if (oldVal == null) {
                                    oldVal = new Long(0L);
                                }
                                this.incLong(attribute, (Long)newVal, (Long)oldVal);
                                continue;
                            }
                            if (classzz == Integer.TYPE) {
                                if (oldVal == null) {
                                    oldVal = new Integer(0);
                                }
                                this.incInt(attribute, (Integer)newVal, (Integer)oldVal);
                                continue;
                            }
                            if (classzz == Float.TYPE) {
                                if (oldVal == null) {
                                    oldVal = new Float(0.0f);
                                }
                                this.incFloat(attribute, (Float)newVal, (Float)oldVal);
                                continue;
                            }
                            if (classzz != Double.TYPE) continue;
                            if (oldVal == null) {
                                oldVal = new Double(0.0);
                            }
                            this.incDouble(attribute, (Double)newVal, (Double)oldVal);
                            continue;
                        }
                        if (oldState == null || newState != null || (oldVal = oldState.get(attribute)) == null) continue;
                        classzz = typeEntry.getValue();
                        if (classzz == Long.TYPE) {
                            this.decLong(attribute, (Long)oldVal);
                            continue;
                        }
                        if (classzz == Integer.TYPE) {
                            this.decInt(attribute, (Integer)oldVal);
                            continue;
                        }
                        if (classzz == Float.TYPE) {
                            this.decFloat(attribute, (Float)oldVal);
                            continue;
                        }
                        if (classzz != Double.TYPE) continue;
                        this.decDouble(attribute, (Double)oldVal);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.fineEnabled()) break block16;
                this.logger.fine("Exception while processing attribute " + attribute);
                this.logger.fine(e);
            }
        }
    }

    public Integer getIntValue(String attributeName) {
        int val = this.aggregateMap.get(attributeName).get().intValue();
        return val < 0 ? -1 : val;
    }

    public Long getLongValue(String attributeName) {
        long val = this.aggregateMap.get(attributeName).get().longValue();
        return val < 0L ? -1L : val;
    }

    public Float getFloatValue(String attributeName) {
        float val = this.aggregateMap.get(attributeName).get().floatValue();
        return Float.valueOf(val < 0.0f ? -1.0f : val);
    }

    public Double getDoubleValue(String attributeName) {
        double val = this.aggregateMap.get(attributeName).get().doubleValue();
        return val < 0.0 ? -1.0 : val;
    }

    public void incLong(String attributeName, Long newVal, Long oldVal) {
        Long curVal;
        Number expectedVal;
        if (newVal.equals(oldVal)) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        while (!ar.compareAndSet(expectedVal = ar.get(), curVal = Long.valueOf(expectedVal.longValue() + (newVal - oldVal)))) {
        }
    }

    public void incInt(String attributeName, Integer newVal, Integer oldVal) {
        Integer curVal;
        Number expectedVal;
        if (newVal.equals(oldVal)) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        while (!ar.compareAndSet(expectedVal = ar.get(), curVal = Integer.valueOf(expectedVal.intValue() + (newVal - oldVal)))) {
        }
    }

    public void incFloat(String attributeName, Float newVal, Float oldVal) {
        Float curVal;
        Number expectedVal;
        if (newVal.equals(oldVal)) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        while (!ar.compareAndSet(expectedVal = ar.get(), curVal = Float.valueOf(expectedVal.floatValue() + (newVal.floatValue() - oldVal.floatValue())))) {
        }
    }

    public void incDouble(String attributeName, Double newVal, Double oldVal) {
        Double curVal;
        Number expectedVal;
        if (newVal.equals(oldVal)) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        while (!ar.compareAndSet(expectedVal = ar.get(), curVal = Double.valueOf(expectedVal.doubleValue() + (newVal - oldVal)))) {
        }
    }

    public void decLong(String attributeName, Long oldVal) {
        Long curVal;
        Number expectedVal;
        if (oldVal == 0L) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        do {
            if ((expectedVal = ar.get()).longValue() == 0L) {
                return;
            }
            curVal = expectedVal.longValue() - oldVal;
        } while (!ar.compareAndSet(expectedVal, curVal));
    }

    public void decInt(String attributeName, Integer oldVal) {
        Integer curVal;
        Number expectedVal;
        if (oldVal == 0) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        do {
            if ((expectedVal = ar.get()).intValue() == 0) {
                return;
            }
            curVal = expectedVal.intValue() - oldVal;
        } while (!ar.compareAndSet(expectedVal, curVal));
    }

    public void decFloat(String attributeName, Float oldVal) {
        Float curVal;
        Number expectedVal;
        if (oldVal.floatValue() == 0.0f) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        do {
            if ((expectedVal = ar.get()).floatValue() == 0.0f) {
                return;
            }
            curVal = Float.valueOf(expectedVal.floatValue() - oldVal.floatValue());
        } while (!ar.compareAndSet(expectedVal, curVal));
    }

    public void decDouble(String attributeName, Double oldVal) {
        Double curVal;
        Number expectedVal;
        if (oldVal == 0.0) {
            return;
        }
        AtomicReference<Number> ar = this.aggregateMap.get(attributeName);
        do {
            if ((expectedVal = ar.get()).doubleValue() == 0.0) {
                return;
            }
            curVal = expectedVal.doubleValue() - oldVal;
        } while (!ar.compareAndSet(expectedVal, curVal));
    }
}

