/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DurableClientCommandsResultBuilder;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CloseDurableCqFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CloseDurableCQsCommand
extends InternalGfshCommand {
    DurableClientCommandsResultBuilder builder = new DurableClientCommandsResultBuilder();

    @CliCommand(value={"close durable-cq"}, help="Closes the durable cq registered by the durable client and drains events held for the durable cq from the subscription queue.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result closeDurableCqs(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id of the durable client") String durableClientId, @CliOption(key={"durable-cq-name"}, mandatory=true, help="Name of the cq to be closed.") String cqName, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the durable client is registered and the cq to be closed.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the durable client is registered and the cq to be closed.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        Result result;
        try {
            Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            String[] params = new String[]{durableClientId, cqName};
            ResultCollector<?, ?> rc = CliUtil.executeFunction(new CloseDurableCqFunction(), params, targetMembers);
            List results = (List)rc.getResult();
            String failureHeader = CliStrings.format("Could not close the durable-cq : \"{0}\" for the durable-client-id : \"{1}\" due to following reasons.", cqName, durableClientId);
            String successHeader = CliStrings.format("Closed the durable cq : \"{0}\" for the durable client : \"{1}\".", cqName, durableClientId);
            result = this.builder.buildResult(results, successHeader, failureHeader);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

