/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DurableClientCommandsResultBuilder;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CloseDurableClientFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CloseDurableClientCommand
extends InternalGfshCommand {
    DurableClientCommandsResultBuilder builder = new DurableClientCommandsResultBuilder();

    @CliCommand(value={"close durable-client"}, help="Attempts to close the durable client, the client must be disconnected.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result closeDurableClient(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the durable client is to be closed.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the subscription queue events are to be counted.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        Result result;
        try {
            Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction(new CloseDurableClientFunction(), durableClientId, targetMembers);
            List results = (List)rc.getResult();
            String failureHeader = CliStrings.format("Unable to close the durable client : \"{0}\" due to following reasons.", (Object)durableClientId);
            String successHeader = CliStrings.format("Closed the durable client : \"{0}\".", (Object)durableClientId);
            result = this.builder.buildResult(results, successHeader, failureHeader);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

