/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ConfigurePDXCommand
extends InternalGfshCommand {
    protected ReflectionBasedAutoSerializer createReflectionBasedAutoSerializer(boolean checkPortability, String[] patterns) {
        return new ReflectionBasedAutoSerializer(checkPortability, patterns);
    }

    protected CacheCreation getCacheCreation(boolean forParsing) {
        return new CacheCreation(forParsing);
    }

    protected XmlEntity createXmlEntity(CacheCreation cache) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CacheXmlGenerator.generate(cache, printWriter, true, false, false);
        printWriter.close();
        String xmlDefinition = stringWriter.toString();
        return XmlEntity.builder().withType("pdx").withConfig(xmlDefinition).build();
    }

    @CliCommand(value={"configure pdx"}, help="Configures Geode's Portable Data eXchange for all the cache(s) in the cluster. This command would not take effect on the running members in the system.\n This command persists the pdx configuration in the locator with cluster configuration service. \n This command should be issued before starting any data members.")
    @CliMetaData(relatedTopic={"Region"}, interceptor="org.apache.geode.management.internal.cli.commands.ConfigurePDXCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result configurePDX(@CliOption(key={"read-serialized"}, help="Set to true to have PDX deserialization produce a PdxInstance instead of an instance of the domain class") Boolean readSerialized, @CliOption(key={"ignore-unread-fields"}, help="Control whether pdx ignores fields that were unread during deserialization. The default is to preserve unread fields be including their data during serialization. But if you configure the cache to ignore unread fields then their data will be lost during serialization.You should only set this attribute to true if you know this member will only be reading cache data. In this use case you do not need to pay the cost of preserving the unread fields since you will never be reserializing pdx data.") Boolean ignoreUnreadFields, @CliOption(key={"disk-store"}, specifiedDefaultValue="", help="Named disk store where the PDX type data will be stored") String diskStore, @CliOption(key={"auto-serializable-classes"}, help="The patterns that are matched against domain class names to determine whether they should be auto-serialized. Serialization done by the auto-serializer will not throw an exception if the object of these classes are not portable to non-java languages (check-portability=false).") String[] nonPortableClassesPatterns, @CliOption(key={"portable-auto-serializable-classes"}, help="The patterns that are matched against domain class names to determine whether they should be serialized. Serialization done by the auto-serializer will throw an exception if the object of these classes are not portable to non-java languages (check-portability=true).") String[] portableClassesPatterns) {
        ReflectionBasedAutoSerializer autoSerializer;
        CacheCreation cache = this.getCacheCreation(true);
        InfoResultData ird = ResultBuilder.createInfoResultData();
        if (!this.getAllNormalMembers().isEmpty()) {
            ird.addLine("The command would only take effect on new data members joining the distributed system. It won't affect the existing data members");
        }
        if (diskStore != null) {
            cache.setPdxPersistent(true);
            ird.addLine("persistent = " + cache.getPdxPersistent());
            if (!diskStore.equals("")) {
                cache.setPdxDiskStore(diskStore);
                ird.addLine("disk-store = " + cache.getPdxDiskStore());
            } else {
                ird.addLine("disk-store = DEFAULT");
            }
        } else {
            cache.setPdxPersistent(false);
            ird.addLine("persistent = " + cache.getPdxPersistent());
        }
        if (readSerialized != null) {
            cache.setPdxReadSerialized(readSerialized);
        } else {
            cache.setPdxReadSerialized(false);
        }
        ird.addLine("read-serialized = " + cache.getPdxReadSerialized());
        if (ignoreUnreadFields != null) {
            cache.setPdxIgnoreUnreadFields(ignoreUnreadFields);
        } else {
            cache.setPdxIgnoreUnreadFields(false);
        }
        ird.addLine("ignore-unread-fields = " + cache.getPdxIgnoreUnreadFields());
        if (portableClassesPatterns != null) {
            autoSerializer = this.createReflectionBasedAutoSerializer(true, portableClassesPatterns);
            cache.setPdxSerializer(autoSerializer);
            ird.addLine("PDX Serializer = " + cache.getPdxSerializer().getClass().getName());
            ird.addLine("Portable Classes = " + Arrays.toString(portableClassesPatterns));
        }
        if (nonPortableClassesPatterns != null) {
            autoSerializer = this.createReflectionBasedAutoSerializer(false, nonPortableClassesPatterns);
            cache.setPdxSerializer(autoSerializer);
            ird.addLine("PDX Serializer = " + cache.getPdxSerializer().getClass().getName());
            ird.addLine("Non Portable Classes = " + Arrays.toString(nonPortableClassesPatterns));
        }
        XmlEntity xmlEntity = this.createXmlEntity(cache);
        CommandResult result = ResultBuilder.buildResult(ird);
        this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).addXmlEntity(xmlEntity, null));
        return result;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String[] portableClassesPatterns = (String[])parseResult.getParamValue("portable-auto-serializable-classes");
            String[] nonPortableClassesPatterns = (String[])parseResult.getParamValue("auto-serializable-classes");
            if (nonPortableClassesPatterns != null && nonPortableClassesPatterns.length > 0 && portableClassesPatterns != null && portableClassesPatterns.length > 0) {
                return ResultBuilder.createUserErrorResult("The autoserializer cannot support both portable and non-portable classes at the same time.");
            }
            return ResultBuilder.createInfoResult("");
        }
    }
}

