/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyJndiBindingFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyJndiBindingCommand
extends InternalGfshCommand {
    static final String DESTROY_JNDIBINDING = "destroy jndi-binding";
    static final String DESTROY_JNDIBINDING__HELP = "Destroy a jndi binding that holds the configuration for the XA datasource.";
    static final String JNDI_NAME = "name";
    static final String JNDI_NAME__HELP = "Name of the binding to be destroyed.";
    static final String IFEXISTS_HELP = "Skip the destroy operation when a jndi binding with the same name does not exists. Without specifying this option, this command execution results into an error.";

    @CliCommand(value={"destroy jndi-binding"}, help="Destroy a jndi binding that holds the configuration for the XA datasource.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result destroyJDNIBinding(@CliOption(key={"name"}, mandatory=true, help="Name of the binding to be destroyed.") String jndiName, @CliOption(key={"if-exists"}, help="Skip the destroy operation when a jndi binding with the same name does not exists. Without specifying this option, this command execution results into an error.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) {
        Set<DistributedMember> targetMembers;
        boolean persisted = false;
        InternalClusterConfigurationService service = (InternalClusterConfigurationService)this.getConfigurationService();
        if (service != null) {
            service.updateCacheConfig("cluster", cc -> {
                List<JndiBindingsType.JndiBinding> bindings = cc.getJndiBindings();
                JndiBindingsType.JndiBinding binding = service.findIdentifiable(bindings, jndiName);
                if (binding == null) {
                    throw new EntityNotFoundException(CliStrings.format("Jndi binding with jndi-name \"{0}\" does not exist.", (Object)jndiName), ifExists);
                }
                bindings.remove(binding);
                return cc;
            });
            persisted = true;
        }
        if ((targetMembers = this.findMembers(null, null)).size() > 0) {
            List<CliFunctionResult> jndiCreationResult = this.executeAndGetFunctionResult(new DestroyJndiBindingFunction(), jndiName, targetMembers);
            return ResultBuilder.buildResult(jndiCreationResult);
        }
        Result result = persisted ? ResultBuilder.createInfoResult(CliStrings.format("No members found. Jndi-binding \"{0}\" is removed from cluster configuration.", (Object)jndiName)) : ResultBuilder.createInfoResult("No members found.");
        result.setCommandPersisted(persisted);
        return result;
    }
}

