/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.GarbageCollectionFunction;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class GCCommand
extends InternalGfshCommand {
    @CliCommand(value={"gc"}, help="Force GC (Garbage Collection) on a member or members. The default is for garbage collection to occur on all caching members.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result gc(@CliOption(key={"group", "groups"}, help="Group(s) of members on which garbage collection will be done.") String[] groups, @CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member on which garbage collection will be done.") String memberId) {
        Result result;
        Cache cache = this.getCache();
        CompositeResultData gcResultTable = ResultBuilder.createCompositeResultData();
        TabularResultData resultTable = gcResultTable.addSection().addTable("Table1");
        String headerText = "GC Summary";
        resultTable.setHeader(headerText);
        HashSet<DistributedMember> dsMembers = new HashSet();
        if (memberId != null && memberId.length() > 0) {
            DistributedMember member = this.getMember(memberId);
            dsMembers.add(member);
            result = this.executeAndBuildResult(resultTable, dsMembers);
        } else if (groups != null && groups.length > 0) {
            for (String group : groups) {
                dsMembers.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
            result = this.executeAndBuildResult(resultTable, dsMembers);
        } else {
            dsMembers = this.getAllNormalMembers();
            result = this.executeAndBuildResult(resultTable, dsMembers);
        }
        return result;
    }

    private Result executeAndBuildResult(TabularResultData resultTable, Set<DistributedMember> dsMembers) {
        GarbageCollectionFunction garbageCollectionFunction = new GarbageCollectionFunction();
        List resultList = (List)CliUtil.executeFunction(garbageCollectionFunction, null, dsMembers).getResult();
        for (Object object : resultList) {
            if (object instanceof Exception) {
                LogWrapper.getInstance(this.getCache()).fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                continue;
            }
            if (object instanceof Throwable) {
                LogWrapper.getInstance(this.getCache()).fine("Exception in GC " + ((Throwable)object).getMessage(), (Throwable)object);
                continue;
            }
            if (object != null) {
                if (object instanceof String) {
                    return ResultBuilder.createUserErrorResult((String)object);
                }
                Map resultMap = (Map)object;
                this.toTabularResultData(resultTable, (String)resultMap.get("MemberId"), (String)resultMap.get("HeapSizeBeforeGC"), (String)resultMap.get("HeapSizeAfterGC"), (String)resultMap.get("TimeSpentInGC"));
                continue;
            }
            LogWrapper.getInstance(this.getCache()).fine("ResultMap was null ");
        }
        return ResultBuilder.buildResult(resultTable);
    }

    private void toTabularResultData(TabularResultData table, String memberId, String heapSizeBefore, String heapSizeAfter, String timeTaken) {
        table.accumulate("Member ID/Name", memberId);
        table.accumulate("HeapSize (MB) Before GC", heapSizeBefore);
        table.accumulate("HeapSize(MB) After GC", heapSizeAfter);
        table.accumulate("Time Taken for GC in ms", timeTaken);
    }
}

