/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.JdkTool;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartJVisualVMCommand
extends InternalGfshCommand {
    @CliCommand(value={"start jvisualvm"}, help="Start the JDK's Java VisualVM (jvisualvm) tool in a separate process. Java VisualVM will be launched, but connecting to Geode must be done manually.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public Result startJVisualVM(@CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Arguments passed to the JVM on which JConsole will run.") String[] jvmArgs) {
        try {
            Object[] jvisualvmCommandLine = this.createJVisualVMCommandLine(jvmArgs);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("JVisualVM command-line (%1$s)", Arrays.toString(jvisualvmCommandLine)));
            }
            Process jvisualvmProcess = Runtime.getRuntime().exec((String[])jvisualvmCommandLine);
            this.getGfsh().printAsInfo("Launched JVisualVM");
            String jvisualvmProcessOutput = ProcessStreamReader.waitAndCaptureProcessStandardErrorStream(jvisualvmProcess);
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            if (StringUtils.isNotBlank((String)jvisualvmProcessOutput)) {
                infoResultData.addLine(StringUtils.LINE_SEPARATOR);
                infoResultData.addLine(jvisualvmProcessOutput);
            }
            return ResultBuilder.buildResult(infoResultData);
        }
        catch (IllegalArgumentException | IllegalStateException | GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching Java VisualVM - %1$s", t.getMessage()));
        }
    }

    protected String[] createJVisualVMCommandLine(String[] jvmArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(JdkTool.getJVisualVMPathname());
        if (jvmArgs != null) {
            for (String arg : jvmArgs) {
                commandLine.add("-J" + arg);
            }
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }
}

