/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.domain.ClassName;
import org.apache.geode.management.internal.cli.functions.RegionAttributesWrapper;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class FetchRegionAttributesFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 4366812590788342070L;
    private static final String ID = FetchRegionAttributesFunction.class.getName();
    public static FetchRegionAttributesFunction INSTANCE = new FetchRegionAttributesFunction();

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void execute(FunctionContext context) {
        try {
            Cache cache = context.getCache();
            String regionPath = (String)context.getArguments();
            if (regionPath == null) {
                throw new IllegalArgumentException("Specify a valid name");
            }
            RegionAttributesWrapper regionAttributesWrapper = FetchRegionAttributesFunction.getRegionAttributes(cache, regionPath);
            context.getResultSender().lastResult(regionAttributesWrapper);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            context.getResultSender().lastResult(e);
        }
    }

    public static RegionAttributesWrapper getRegionAttributes(Cache cache, String regionPath) {
        AbstractRegion foundRegion = (AbstractRegion)cache.getRegion(regionPath);
        if (foundRegion == null) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", regionPath));
        }
        AttributesFactory afactory = new AttributesFactory(foundRegion.getAttributes());
        RegionAttributesWrapper result = new RegionAttributesWrapper();
        CacheListener[] cacheListeners = foundRegion.getCacheListeners();
        List<ClassName<CacheListener>> existingCacheListeners = Arrays.stream(cacheListeners).map(c -> new ClassName(c.getClass().getName())).collect(Collectors.toList());
        result.setCacheListenerClasses(existingCacheListeners);
        afactory.initCacheListeners(null);
        if (foundRegion.getCacheLoader() != null) {
            result.setCacheLoaderClass(new ClassName<CacheLoader>(foundRegion.getCacheLoader().getClass().getName()));
            afactory.setCacheLoader(null);
        }
        if (foundRegion.getCacheWriter() != null) {
            result.setCacheWriterClass(new ClassName<CacheWriter>(foundRegion.getCacheWriter().getClass().getName()));
            afactory.setCacheWriter(null);
        }
        if (foundRegion.getCompressor() != null) {
            result.setCompressorClass(foundRegion.getCompressor().getClass().getName());
            afactory.setCompressor(null);
        }
        if (foundRegion.getKeyConstraint() != null) {
            result.setKeyConstraintClass(foundRegion.getKeyConstraint().getName());
            afactory.setKeyConstraint(null);
        }
        if (foundRegion.getValueConstraint() != null) {
            result.setValueConstraintClass(foundRegion.getValueConstraint().getName());
            afactory.setValueConstraint(null);
        }
        result.setRegionAttributes(afactory.create());
        return result;
    }

    @Override
    public String getId() {
        return ID;
    }
}

