/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.domain.AsyncEventQueueDetails;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ListAsyncEventQueuesFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            Set<AsyncEventQueue> asyncEventQueues = cache.getAsyncEventQueues();
            Serializable[] asyncEventQueueDetails = new AsyncEventQueueDetails[asyncEventQueues.size()];
            int i = 0;
            for (AsyncEventQueue queue : asyncEventQueues) {
                AsyncEventListener listener = queue.getAsyncEventListener();
                Properties listenerProperties = new Properties();
                if (listener instanceof Declarable2) {
                    listenerProperties = ((Declarable2)((Object)listener)).getConfig();
                }
                asyncEventQueueDetails[i++] = new AsyncEventQueueDetails(queue.getId(), queue.getBatchSize(), queue.isPersistent(), queue.getDiskStoreName(), queue.getMaximumQueueMemory(), listener.getClass().getName(), listenerProperties);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, asyncEventQueueDetails);
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not list async event queues: {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }
}

