/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;

public class ResultBuilder {
    public static final int CODE_SHELLCLIENT_ABORT_OP = 110;
    public static final int ERRORCODE_DEFAULT = 400;
    public static final int ERRORCODE_CONNECTION_ERROR = 405;
    public static final int ERRORCODE_SHELLCLIENT_ERROR = 410;
    public static final int ERRORCODE_UNAUTHORIZED = 415;
    public static final int ERRORCODE_PARSING_ERROR = 501;
    public static final int ERRORCODE_GEODE_ERROR = 505;
    public static final int ERRORCODE_BADRESPONSE_ERROR = 510;
    public static final int ERRORCODE_BADCONFIG_ERROR = 515;
    public static final int ERRORCODE_USER_ERROR = 520;

    public static CommandResult createConnectionErrorResult(String message) {
        String errorMessage = message != null ? message : "Connection Error occurred.";
        return ResultBuilder.createErrorResult(405, errorMessage);
    }

    public static CommandResult createShellClientErrorResult(String message) {
        return ResultBuilder.createErrorResult(410, message);
    }

    public static CommandResult createShellClientAbortOperationResult(String message) {
        return ResultBuilder.createErrorResult(110, message);
    }

    public static CommandResult createParsingErrorResult(String message) {
        return ResultBuilder.createErrorResult(501, "Could not parse command string. " + message);
    }

    public static CommandResult createBadConfigurationErrorResult(String message) {
        return ResultBuilder.createErrorResult(515, "Configuration error. " + message);
    }

    public static CommandResult createGemFireErrorResult(String message) {
        return ResultBuilder.createErrorResult(505, "Could not process command due to error. " + message);
    }

    public static CommandResult createGemFireUnAuthorizedErrorResult(String message) {
        return ResultBuilder.createErrorResult(415, message);
    }

    public static CommandResult createUserErrorResult(String message) {
        return ResultBuilder.createErrorResult(520, message);
    }

    public static CommandResult createBadResponseErrorResult(String message) {
        return ResultBuilder.createErrorResult(510, "Could not read command response. " + message);
    }

    private static CommandResult createErrorResult(int errorCode, String message) {
        ErrorResultData errorResultData = new ErrorResultData();
        errorResultData.setErrorCode(errorCode);
        errorResultData.addLine(message);
        return ResultBuilder.buildResult(errorResultData);
    }

    public static Result createInfoResult(String message) {
        InfoResultData infoResultData = new InfoResultData();
        infoResultData.addLine(message);
        return ResultBuilder.buildResult(infoResultData);
    }

    public static TabularResultData createTabularResultData() {
        return new TabularResultData();
    }

    public static CompositeResultData createCompositeResultData() {
        return new CompositeResultData();
    }

    public static InfoResultData createInfoResultData() {
        return new InfoResultData();
    }

    public static ErrorResultData createErrorResultData() {
        return new ErrorResultData();
    }

    public static CommandResult buildResult(ResultData resultData) {
        return new CommandResult(resultData);
    }

    public static CommandResult buildResult(List<CliFunctionResult> functionResults) {
        TabularResultData tabularData = ResultBuilder.createTabularResultData();
        boolean success = false;
        for (CliFunctionResult result : functionResults) {
            tabularData.accumulate("Member", result.getMemberIdOrName());
            tabularData.accumulate("Status", result.getStatus());
            if (!result.isSuccessful()) continue;
            success = true;
        }
        tabularData.setStatus(success ? Result.Status.OK : Result.Status.ERROR);
        return ResultBuilder.buildResult(tabularData);
    }

    public static CommandResult fromJson(GfJsonObject gfJsonObject) {
        return ResultBuilder.fromJson(gfJsonObject.toString());
    }

    public static CommandResult fromJson(String json) {
        CommandResult result;
        try {
            AbstractResultData resultData;
            GfJsonObject jsonObject = new GfJsonObject(json);
            String contentType = jsonObject.getString("contentType");
            GfJsonObject data = jsonObject.getJSONObject("data");
            if ("table".equals(contentType)) {
                resultData = new TabularResultData(data);
            } else if ("info".equals(contentType)) {
                resultData = new InfoResultData(data);
            } else if ("error".equals(contentType)) {
                resultData = new ErrorResultData(data);
            } else if ("composite".equals(contentType)) {
                resultData = new CompositeResultData(data);
            } else {
                ErrorResultData errorResultData = new ErrorResultData();
                errorResultData.addLine("Can not detect result type, unknown response format: " + json);
                resultData = errorResultData;
            }
            Integer statusCode = (Integer)jsonObject.get("status");
            if (Result.Status.OK.getCode() == statusCode.intValue()) {
                resultData.setStatus(Result.Status.OK);
            } else {
                resultData.setStatus(Result.Status.ERROR);
            }
            result = ResultBuilder.buildResult(resultData);
            String fileToDownloadPath = jsonObject.getString("fileToDownload");
            if (StringUtils.isNotBlank((String)fileToDownloadPath) && !fileToDownloadPath.equals("null")) {
                result.setFileToDownload(Paths.get(fileToDownloadPath, new String[0]));
            }
        }
        catch (GfJsonException e) {
            result = ResultBuilder.createBadResponseErrorResult(json);
        }
        return result;
    }

    public static String resultAsString(Result result) {
        StringBuilder builder = new StringBuilder();
        if (result != null) {
            while (result.hasNextLine()) {
                builder.append(result.nextLine());
            }
        }
        return builder.toString();
    }

    static ResultData getReadOnlyResultData(ResultData resultData) {
        AbstractResultData wrapperResultData;
        String contentType = resultData.getType();
        if ("table".equals(contentType)) {
            wrapperResultData = new TabularResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public TabularResultData accumulate(String accumulateFor, Object value) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("info".equals(contentType)) {
            wrapperResultData = new InfoResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData addLine(String line) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("error".equals(contentType)) {
            wrapperResultData = new ErrorResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData addLine(String line) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ErrorResultData setErrorCode(int errorCode) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else if ("composite".equals(contentType)) {
            wrapperResultData = new CompositeResultData(resultData.getGfJsonObject()){

                @Override
                public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData.SectionResultData addSection() {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData.SectionResultData addSection(String keyToRetrieve) {
                    throw new UnsupportedOperationException("This is read only result data");
                }

                @Override
                public CompositeResultData addSeparator(char buildSeparatorFrom) {
                    throw new UnsupportedOperationException("This is read only result data");
                }
            };
        } else {
            ErrorResultData errorResultData = new ErrorResultData();
            errorResultData.addLine("Can not detect result type, unknown result data format for: " + resultData);
            wrapperResultData = errorResultData;
        }
        return wrapperResultData;
    }
}

