/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.callbacks;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.logging.log4j.Logger;

public class ConfigurationChangeListener
extends CacheListenerAdapter<String, Configuration> {
    private static final Logger logger = LogService.getLogger();
    private final InternalClusterConfigurationService sharedConfig;
    private final InternalCache cache;

    public ConfigurationChangeListener(InternalClusterConfigurationService sharedConfig, InternalCache cache) {
        this.sharedConfig = sharedConfig;
        this.cache = cache;
    }

    @Override
    public void afterUpdate(EntryEvent<String, Configuration> event) {
        super.afterUpdate(event);
        if (event.isOriginRemote()) {
            this.addOrRemoveJarFromFilesystem(event);
        }
    }

    @Override
    public void afterCreate(EntryEvent<String, Configuration> event) {
        super.afterCreate(event);
        if (event.isOriginRemote()) {
            this.addOrRemoveJarFromFilesystem(event);
        }
    }

    private void addOrRemoveJarFromFilesystem(EntryEvent<String, Configuration> event) {
        String group = event.getKey();
        Configuration newConfig = event.getNewValue();
        Configuration oldConfig = event.getOldValue();
        Set<String> newJars = newConfig.getJarNames();
        Set<Object> oldJars = oldConfig == null ? new HashSet() : oldConfig.getJarNames();
        HashSet jarsRemoved = new HashSet(oldJars);
        jarsRemoved.removeAll(newJars);
        for (String jarRemoved : jarsRemoved) {
            File jar = this.sharedConfig.getPathToJarOnThisLocator(group, jarRemoved).toFile();
            if (!jar.exists()) continue;
            try {
                FileUtils.forceDelete((File)jar);
            }
            catch (IOException e) {
                logger.error("Exception occurred while attempting to delete a jar from the filesystem: {}", (Object)jarRemoved, (Object)e);
            }
        }
        String triggerMemberId = (String)event.getCallbackArgument();
        DistributedMember locator = this.getDistributedMember(triggerMemberId);
        for (String jarAdded : newJars) {
            try {
                this.sharedConfig.downloadJarFromLocator(group, jarAdded, locator);
            }
            catch (Exception e) {
                logger.error("Unable to add jar: " + jarAdded, (Throwable)e);
            }
        }
    }

    private DistributedMember getDistributedMember(String memberName) {
        HashSet<InternalDistributedMember> locators = new HashSet<InternalDistributedMember>(this.cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        Optional<DistributedMember> locator = locators.stream().filter(x -> x.getId().equals(memberName)).findFirst();
        return locator.get();
    }
}

