/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.logging.log4j.Logger;

public class GetClusterConfigurationFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void execute(FunctionContext context) {
        InternalClusterConfigurationService clusterConfigurationService = InternalLocator.getLocator().getSharedConfiguration();
        Set groups = (Set)context.getArguments();
        logger.info("Received request for configuration  : {}", (Object)groups);
        try {
            ConfigurationResponse response = clusterConfigurationService.createConfigurationResponse(groups);
            context.getResultSender().lastResult(response);
        }
        catch (IOException e) {
            logger.error("Unable to retrieve the cluster configuration", (Throwable)e);
            context.getResultSender().lastResult(e);
        }
    }
}

