/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.internal.AddPDXEnumOp;
import org.apache.geode.cache.client.internal.AddPDXTypeOp;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.GetPDXEnumByIdOp;
import org.apache.geode.cache.client.internal.GetPDXEnumsOp;
import org.apache.geode.cache.client.internal.GetPDXIdForEnumOp;
import org.apache.geode.cache.client.internal.GetPDXIdForTypeOp;
import org.apache.geode.cache.client.internal.GetPDXTypeByIdOp;
import org.apache.geode.cache.client.internal.GetPDXTypesOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistration;
import org.apache.logging.log4j.Logger;

public class ClientTypeRegistration
implements TypeRegistration {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;

    public ClientTypeRegistration(InternalCache cache) {
        this.cache = cache;
    }

    @Override
    public int defineType(PdxType newType) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        int newTypeId = -1;
        for (Pool pool : pools) {
            try {
                newTypeId = GetPDXIdForTypeOp.execute((ExecutablePool)((Object)pool), newType);
                newType.setTypeId(newTypeId);
                this.sendTypeToPool(newType, newTypeId, pool);
                return newTypeId;
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        throw this.returnCorrectExceptionForFailure(pools, newTypeId, lastException);
    }

    private void sendTypeToPool(PdxType type, int id, Pool pool) {
        try {
            AddPDXTypeOp.execute((ExecutablePool)((Object)pool), id, type);
        }
        catch (ServerConnectivityException serverConnectivityException) {
            logger.debug("Received an exception sending pdx type to pool {}, {}", (Object)pool, (Object)serverConnectivityException.getMessage(), (Object)serverConnectivityException);
            throw serverConnectivityException;
        }
    }

    @Override
    public PdxType getType(int typeId) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                PdxType type = GetPDXTypeByIdOp.execute((ExecutablePool)((Object)pool), typeId);
                if (type == null) continue;
                return type;
            }
            catch (ServerConnectivityException e) {
                logger.debug("Received an exception getting pdx type from pool {}, {}", (Object)pool, (Object)e.getMessage(), (Object)e);
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw this.returnCorrectExceptionForFailure(pools, typeId, lastException);
    }

    private Collection<Pool> getAllPools() {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        if (pools.isEmpty()) {
            if (this.cache.isClosed()) {
                throw this.cache.getCacheClosedException("PDX detected cache was closed");
            }
            throw this.cache.getCacheClosedException("Client pools have been closed so the PDX type registry is not available.");
        }
        return pools;
    }

    @Override
    public void addRemoteType(int typeId, PdxType type) {
        throw new UnsupportedOperationException("Clients will not be asked to add remote types");
    }

    @Override
    public int getLastAllocatedTypeId() {
        throw new UnsupportedOperationException("Clients does not keep track of last allocated id");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void gatewaySenderStarted(GatewaySender gatewaySender) {
    }

    @Override
    public void creatingPersistentRegion() {
    }

    @Override
    public void creatingPool() {
    }

    @Override
    public int getEnumId(Enum<?> v) {
        EnumInfo enumInfo = new EnumInfo(v);
        return this.processEnumInfoForEnumId(enumInfo);
    }

    private int processEnumInfoForEnumId(EnumInfo enumInfo) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                int result = GetPDXIdForEnumOp.execute((ExecutablePool)((Object)pool), enumInfo);
                this.sendEnumIdToPool(enumInfo, result, pool);
                return result;
            }
            catch (ServerConnectivityException e) {
                lastException = e;
            }
        }
        throw this.returnCorrectExceptionForFailure(pools, -1, lastException);
    }

    private void sendEnumIdToPool(EnumInfo enumInfo, int id, Pool pool) {
        try {
            AddPDXEnumOp.execute((ExecutablePool)((Object)pool), id, enumInfo);
        }
        catch (ServerConnectivityException serverConnectivityException) {
            logger.debug("Received an exception sending pdx type to pool {}, {}", (Object)pool, (Object)serverConnectivityException.getMessage(), (Object)serverConnectivityException);
            throw serverConnectivityException;
        }
    }

    @Override
    public void addRemoteEnum(int enumId, EnumInfo newInfo) {
        throw new UnsupportedOperationException("Clients will not be asked to add remote enums");
    }

    @Override
    public int defineEnum(EnumInfo newInfo) {
        return this.processEnumInfoForEnumId(newInfo);
    }

    @Override
    public EnumInfo getEnumById(int enumId) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                EnumInfo result = GetPDXEnumByIdOp.execute((ExecutablePool)((Object)pool), enumId);
                if (result == null) continue;
                return result;
            }
            catch (ServerConnectivityException e) {
                logger.debug("Received an exception getting pdx type from pool {}, {}", (Object)pool, (Object)e.getMessage(), (Object)e);
                lastException = e;
            }
        }
        throw this.returnCorrectExceptionForFailure(pools, enumId, lastException);
    }

    @Override
    public Map<Integer, PdxType> types() {
        Collection<Pool> pools = this.getAllPools();
        HashMap<Integer, PdxType> types = new HashMap<Integer, PdxType>();
        for (Pool p : pools) {
            try {
                types.putAll(GetPDXTypesOp.execute((ExecutablePool)((Object)p)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return types;
    }

    @Override
    public Map<Integer, EnumInfo> enums() {
        Collection<Pool> pools = this.getAllPools();
        HashMap<Integer, EnumInfo> enums = new HashMap<Integer, EnumInfo>();
        for (Pool p : pools) {
            enums.putAll(GetPDXEnumsOp.execute((ExecutablePool)((Object)p)));
        }
        return enums;
    }

    @Override
    public PdxType getPdxTypeForField(String fieldName, String className) {
        for (PdxType value : this.types().values()) {
            PdxType pdxType;
            if (!(value instanceof PdxType) || !(pdxType = value).getClassName().equals(className) || pdxType.getPdxField(fieldName) == null) continue;
            return pdxType;
        }
        return null;
    }

    @Override
    public Set<PdxType> getPdxTypesForClassName(String className) {
        HashSet<PdxType> result = new HashSet<PdxType>();
        for (PdxType value : this.types().values()) {
            PdxType pdxType;
            if (!(value instanceof PdxType) || !(pdxType = value).getClassName().equals(className)) continue;
            result.add(pdxType);
        }
        return result;
    }

    @Override
    public void testClearRegistry() {
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void addImportedType(int typeId, PdxType importedType) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                this.sendTypeToPool(importedType, typeId, pool);
            }
            catch (ServerConnectivityException e) {
                lastException = e;
                break;
            }
        }
        if (lastException == null) {
            return;
        }
        throw this.returnCorrectExceptionForFailure(pools, typeId, lastException);
    }

    @Override
    public void addImportedEnum(int enumId, EnumInfo importedInfo) {
        Collection<Pool> pools = this.getAllPools();
        ServerConnectivityException lastException = null;
        for (Pool pool : pools) {
            try {
                this.sendEnumIdToPool(importedInfo, enumId, pool);
            }
            catch (ServerConnectivityException e) {
                lastException = e;
                break;
            }
        }
        if (lastException == null) {
            return;
        }
        throw this.returnCorrectExceptionForFailure(pools, enumId, lastException);
    }

    private RuntimeException returnCorrectExceptionForFailure(Collection<Pool> pools, int typeId, ServerConnectivityException lastException) {
        if (lastException != null) {
            throw lastException;
        }
        throw new InternalGemFireError("Unable to determine PDXType for id " + typeId);
    }

    @Override
    public int getLocalSize() {
        return 0;
    }
}

