/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.Authorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCache;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingLocator;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingLocatorImpl;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.NoSecurityAuthorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.NotLoggedInAuthorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.ShiroAuthorizer;
import org.apache.geode.internal.protocol.protobuf.v1.state.TerminateConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.protocol.serialization.ValueSerializer;
import org.apache.shiro.subject.Subject;

@Experimental
public class LocatorMessageExecutionContext
extends MessageExecutionContext {
    private final Locator locator;
    private AuthorizingLocator authorizingLocator;

    public LocatorMessageExecutionContext(Locator locator, ClientStatistics statistics, SecurityService securityService) {
        super(statistics, securityService);
        this.locator = locator;
        Authorizer authorizer = securityService.isIntegratedSecurity() ? new NotLoggedInAuthorizer() : new NoSecurityAuthorizer();
        this.authorizingLocator = new AuthorizingLocatorImpl(locator, authorizer);
    }

    @Override
    public AuthorizingCache getAuthorizingCache() throws InvalidExecutionContextException {
        this.setState(new TerminateConnection());
        throw new InvalidExecutionContextException("Operations on the locator should not to try to operate on a server");
    }

    @Override
    public AuthorizingLocator getAuthorizingLocator() throws InvalidExecutionContextException {
        return this.authorizingLocator;
    }

    @Override
    public void authenticate(Properties properties) {
        Subject subject = this.securityService.login(properties);
        this.authorizingLocator = new AuthorizingLocatorImpl(this.locator, new ShiroAuthorizer(this.securityService, subject));
    }

    @Override
    public void setValueSerializer(ValueSerializer valueSerializer) {
    }
}

