/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.Authorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCache;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCacheImpl;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingLocator;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.NoSecurityAuthorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.NotLoggedInAuthorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.ShiroAuthorizer;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.protocol.serialization.ValueSerializer;
import org.apache.shiro.subject.Subject;

@Experimental
public class ServerMessageExecutionContext
extends MessageExecutionContext {
    private final InternalCache cache;
    private AuthorizingCache authorizingCache;

    public ServerMessageExecutionContext(InternalCache cache, ClientStatistics statistics, SecurityService securityService) {
        super(statistics, securityService);
        this.cache = cache;
        Authorizer authorizer = securityService.isIntegratedSecurity() ? new NotLoggedInAuthorizer() : new NoSecurityAuthorizer();
        this.authorizingCache = new AuthorizingCacheImpl(cache, authorizer);
    }

    @Override
    public AuthorizingCache getAuthorizingCache() {
        return this.authorizingCache;
    }

    @Override
    public AuthorizingLocator getAuthorizingLocator() throws InvalidExecutionContextException {
        throw new InvalidExecutionContextException("Operations on the server should not to try to operate on a locator");
    }

    @Override
    public void authenticate(Properties properties) {
        Subject subject = this.securityService.login(properties);
        this.authorizingCache = new AuthorizingCacheImpl(this.cache, new ShiroAuthorizer(this.securityService, subject));
    }

    @Override
    public void setValueSerializer(ValueSerializer valueSerializer) {
        valueSerializer.init((Cache)this.cache);
        this.serializationService = new ProtobufSerializationService(valueSerializer);
    }
}

