/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.authentication;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.Authorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCache;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingFunctionService;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingFunctionServiceImpl;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class AuthorizingCacheImpl
implements AuthorizingCache {
    protected final InternalCache cache;
    protected final Authorizer authorizer;
    private final AuthorizingFunctionService functionService;

    public AuthorizingCacheImpl(InternalCache cache, Authorizer authorizer) {
        this.cache = cache;
        this.authorizer = authorizer;
        this.functionService = new AuthorizingFunctionServiceImpl(cache, authorizer);
    }

    @Override
    public <K, V> void getAll(String regionName, Iterable<K> keys, BiConsumer<K, V> successConsumer, BiConsumer<K, Exception> failureConsumer) {
        Region region = this.getRegion(regionName);
        boolean authorized = this.tryAuthorizeAllKeys(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        keys.forEach(key -> {
            try {
                if (!authorized) {
                    this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
                }
                Object value = region.get(key);
                successConsumer.accept(key, value);
            }
            catch (Exception e) {
                failureConsumer.accept(key, e);
            }
        });
    }

    @Override
    public <K, V> V get(String regionName, K key) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        return (V)region.get(key);
    }

    @Override
    public <K, V> void put(String regionName, K key, V value) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        region.put(key, value);
    }

    @Override
    public <K, V> void putAll(String regionName, Map<K, V> entries, BiConsumer<K, Exception> failureConsumer) {
        boolean authorized = this.tryAuthorizeAllKeys(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        Region region = this.getRegion(regionName);
        entries.forEach((key, value) -> {
            try {
                if (!authorized) {
                    this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
                }
                region.put(key, value);
            }
            catch (Exception e) {
                failureConsumer.accept(key, e);
            }
        });
    }

    @Override
    public <K, V> V remove(String regionName, K key) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        return (V)region.remove(key);
    }

    @Override
    public Collection<String> getRegionNames() {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, ResourcePermission.ALL, ResourcePermission.ALL);
        HashSet<String> regionNames = new HashSet<String>();
        this.cache.rootRegions().forEach(region -> {
            regionNames.add(region.getFullPath());
            region.subregions(true).stream().map(Region::getFullPath).forEach(regionNames::add);
        });
        return regionNames;
    }

    @Override
    public int getSize(String regionName) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, ResourcePermission.ALL);
        return this.getRegion(regionName).size();
    }

    @Override
    public <K> Set<K> keySet(String regionName) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, ResourcePermission.ALL);
        return this.getRegion(regionName).keySet();
    }

    @Override
    public AuthorizingFunctionService getFunctionService() {
        return this.functionService;
    }

    @Override
    public void clear(String regionName) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, ResourcePermission.ALL);
        Region region = this.getRegion(regionName);
        region.clear();
    }

    @Override
    public <K, V> V putIfAbsent(String regionName, K key, V value) {
        this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key);
        Region<K, V> region = this.getRegion(regionName);
        return (V)region.putIfAbsent(key, value);
    }

    @Override
    public Object query(String queryString, Object[] bindParameters) throws NameResolutionException, TypeMismatchException, QueryInvocationTargetException, FunctionDomainException {
        InternalQueryService queryService = this.cache.getQueryService();
        Query query = queryService.newQuery(queryString);
        for (String regionName : ((DefaultQuery)query).getRegionsInQuery(bindParameters)) {
            this.authorizer.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, ResourcePermission.ALL);
        }
        return query.execute(bindParameters);
    }

    private <K, V> Region<K, V> getRegion(String regionName) {
        Region region = this.cache.getRegion(regionName);
        if (region == null) {
            throw new RegionDestroyedException("Region not found " + regionName, regionName);
        }
        return region;
    }

    private boolean tryAuthorizeAllKeys(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String regionName) {
        try {
            this.authorizer.authorize(resource, operation, regionName, ResourcePermission.ALL);
            return true;
        }
        catch (NotAuthorizedException e) {
            return false;
        }
    }
}

