/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetSizeRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetSizeRequest, RegionAPI.GetSizeResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.GetSizeResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetSizeRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException {
        String regionName = request.getRegionName();
        int size = messageExecutionContext.getAuthorizingCache().getSize(regionName);
        return Success.of(RegionAPI.GetSizeResponse.newBuilder().setSize(size).build());
    }
}

