/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.results;

import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.lucene.internal.results.PageEntry;
import org.apache.geode.cache.lucene.internal.results.PageResults;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LuceneGetPageFunction
implements InternalFunction<Object> {
    private static final long serialVersionUID = 1L;
    public static final String ID = LuceneGetPageFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext context) {
        try {
            RegionFunctionContext ctx = (RegionFunctionContext)context;
            Region region = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)ctx);
            Set keys = ctx.getFilter();
            PageResults results = new PageResults(keys.size());
            for (Object key : keys) {
                PageEntry entry = this.getEntry(region, key);
                if (entry == null) continue;
                results.add(entry);
            }
            ctx.getResultSender().lastResult((Object)results);
        }
        catch (CacheClosedException | PrimaryBucketException e) {
            logger.debug("Exception during lucene query function", e);
            throw new InternalFunctionInvocationTargetException(e);
        }
    }

    protected PageEntry getEntry(Region region, Object key) {
        EntrySnapshot entry = (EntrySnapshot)region.getEntry(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.getRegionEntry().getValue(null);
        if (value == null || Token.isInvalidOrRemoved((Object)value)) {
            return null;
        }
        return new PageEntry(key, value);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }
}

