/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FieldInfo
extends ScanResult.InfoObject
implements Comparable<FieldInfo> {
    private final String className;
    private final String fieldName;
    private final int modifiers;
    private final String typeDescriptorStr;
    private final String typeSignatureStr;
    private TypeSignature typeSignature;
    private final Object constValue;
    final List<AnnotationInfo> annotationInfo;
    private ScanResult scanResult;

    @Override
    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
    }

    public FieldInfo(String className, String fieldName, int modifiers, String typeDescriptorStr, String typeSignatureStr, Object constValue, List<AnnotationInfo> annotationInfo) {
        this.className = className;
        this.fieldName = fieldName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.constValue = constValue;
        this.annotationInfo = annotationInfo == null || annotationInfo.isEmpty() ? Collections.emptyList() : annotationInfo;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getModifierStrs() {
        return TypeUtils.modifiersToString(this.modifiers, false);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getTypeDescriptorStr() {
        return this.typeDescriptorStr;
    }

    public String getTypeSignatureStr() {
        return this.typeSignatureStr;
    }

    public TypeSignature getTypeSignature() {
        if (this.typeSignature == null) {
            this.typeSignature = TypeSignature.parse(this.typeSignatureStr != null ? this.typeSignatureStr : this.typeDescriptorStr);
        }
        return this.typeSignature;
    }

    public Class<?> getType() throws IllegalArgumentException {
        return this.getTypeSignature().instantiate(this.scanResult);
    }

    public String getTypeStr() {
        return this.getTypeSignature().toString();
    }

    public Object getConstFinalValue() {
        return this.constValue;
    }

    public List<String> getAnnotationNames() {
        return Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        return this.className.equals(other.className) && this.fieldName.equals(other.fieldName);
    }

    public int hashCode() {
        return this.fieldName.hashCode() + this.className.hashCode() * 11;
    }

    @Override
    public int compareTo(FieldInfo other) {
        int diff = this.className.compareTo(other.className);
        if (diff != 0) {
            return diff;
        }
        return this.fieldName.compareTo(other.fieldName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(annotation.toString());
            }
        }
        if (this.modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            TypeUtils.modifiersToString(this.modifiers, false, buf);
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getTypeStr());
        buf.append(' ');
        buf.append(this.fieldName);
        if (this.constValue != null) {
            buf.append(" = ");
            if (this.constValue instanceof String) {
                buf.append("\"" + ((String)this.constValue).replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
            } else if (this.constValue instanceof Character) {
                buf.append("'" + ((Character)this.constValue).toString().replace("\\", "\\\\").replaceAll("'", "\\'") + "'");
            } else {
                buf.append(this.constValue.toString());
            }
        }
        return buf.toString();
    }
}

