/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.JdbcDataSource;
import org.apache.geode.connectors.jdbc.internal.JdbcDataSourceFactory;

class DataSourceManager {
    private final JdbcDataSourceFactory jdbcDataSourceFactory;
    private final Map<String, JdbcDataSource> dataSourceMap = new ConcurrentHashMap<String, JdbcDataSource>();

    DataSourceManager(JdbcDataSourceFactory jdbcDataSourceFactory) {
        this.jdbcDataSourceFactory = jdbcDataSourceFactory;
    }

    JdbcDataSource getOrCreateDataSource(ConnectionConfiguration config) {
        return this.dataSourceMap.computeIfAbsent(config.getName(), k -> this.jdbcDataSourceFactory.create(config));
    }

    synchronized void close() {
        this.dataSourceMap.values().forEach(this::close);
        this.dataSourceMap.clear();
    }

    private void close(JdbcDataSource dataSource) {
        try {
            dataSource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

