/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import org.apache.geode.connectors.jdbc.internal.ColumnData;
import org.apache.geode.connectors.jdbc.internal.EntryColumnData;

class SqlStatementFactory {
    private final String quote;

    public SqlStatementFactory(String identifierQuoteString) {
        this.quote = identifierQuoteString;
    }

    String createSelectQueryString(String tableName, EntryColumnData entryColumnData) {
        ColumnData keyCV = entryColumnData.getEntryKeyColumnData();
        return "SELECT * FROM " + this.quoteIdentifier(tableName) + " WHERE " + this.quoteIdentifier(keyCV.getColumnName()) + " = ?";
    }

    String createDestroySqlString(String tableName, EntryColumnData entryColumnData) {
        ColumnData keyCV = entryColumnData.getEntryKeyColumnData();
        return "DELETE FROM " + this.quoteIdentifier(tableName) + " WHERE " + this.quoteIdentifier(keyCV.getColumnName()) + " = ?";
    }

    String createUpdateSqlString(String tableName, EntryColumnData entryColumnData) {
        StringBuilder query = new StringBuilder("UPDATE " + this.quoteIdentifier(tableName) + " SET ");
        int idx = 0;
        for (ColumnData column : entryColumnData.getEntryValueColumnData()) {
            if (++idx > 1) {
                query.append(", ");
            }
            query.append(this.quoteIdentifier(column.getColumnName()));
            query.append(" = ?");
        }
        ColumnData keyColumnData = entryColumnData.getEntryKeyColumnData();
        query.append(" WHERE ");
        query.append(this.quoteIdentifier(keyColumnData.getColumnName()));
        query.append(" = ?");
        return query.toString();
    }

    String createInsertSqlString(String tableName, EntryColumnData entryColumnData) {
        StringBuilder columnNames = new StringBuilder("INSERT INTO " + this.quoteIdentifier(tableName) + " (");
        StringBuilder columnValues = new StringBuilder(" VALUES (");
        for (ColumnData column : entryColumnData.getEntryValueColumnData()) {
            columnNames.append(this.quoteIdentifier(column.getColumnName())).append(", ");
            columnValues.append("?,");
        }
        ColumnData keyColumnData = entryColumnData.getEntryKeyColumnData();
        columnNames.append(this.quoteIdentifier(keyColumnData.getColumnName())).append(")");
        columnValues.append("?)");
        return columnNames.append((CharSequence)columnValues).toString();
    }

    private String quoteIdentifier(String identifier) {
        return this.quote + identifier + this.quote;
    }
}

