/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigBuilder;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.cli.CreateConnectionFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateConnectionCommand
extends InternalGfshCommand {
    private static final Logger logger = LogService.getLogger();
    static final String CREATE_CONNECTION = "create jdbc-connection";
    static final String CREATE_CONNECTION__HELP = "(Experimental) Create a connection for communicating with a database through jdbc.";
    static final String CREATE_CONNECTION__NAME = "name";
    static final String CREATE_CONNECTION__NAME__HELP = "Name of the connection to be created.";
    static final String CREATE_CONNECTION__URL = "url";
    static final String CREATE_CONNECTION__URL__HELP = "URL location for the database.";
    static final String CREATE_CONNECTION__USER = "user";
    static final String CREATE_CONNECTION__USER__HELP = "User name to use when connecting to database.";
    static final String CREATE_CONNECTION__PASSWORD = "password";
    static final String CREATE_CONNECTION__PASSWORD__HELP = "Password to use when connecting to database.";
    static final String CREATE_CONNECTION__PARAMS = "params";
    static final String CREATE_CONNECTION__PARAMS__HELP = "Additional parameters to use when connecting to the database formatted like \"key:value(,key:value)*\".";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"create jdbc-connection"}, help="(Experimental) Create a connection for communicating with a database through jdbc.")
    @CliMetaData(relatedTopic={"Geode"}, interceptor="org.apache.geode.connectors.jdbc.internal.cli.CreateConnectionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result createConnection(@CliOption(key={"name"}, mandatory=true, help="Name of the connection to be created.") String name, @CliOption(key={"url"}, mandatory=true, help="URL location for the database.") String url, @CliOption(key={"user"}, help="User name to use when connecting to database.") String user, @CliOption(key={"password"}, help="Password to use when connecting to database.") String password, @CliOption(key={"params"}, help="Additional parameters to use when connecting to the database formatted like \"key:value(,key:value)*\".") String[] params) {
        Set targetMembers = this.getMembers(null, null);
        ConnectionConfiguration configuration = this.getArguments(name, url, user, password, params);
        ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector = this.execute(new CreateConnectionFunction(), configuration, targetMembers);
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        XmlEntity xmlEntity = this.fillTabularResultData(resultCollector, tabularResultData);
        tabularResultData.setHeader("(Experimental) ");
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResultData);
        this.updateClusterConfiguration((Result)result, xmlEntity);
        return result;
    }

    ConnectionConfiguration getArguments(String name, String url, String user, String password, String[] params) {
        ConnectionConfigBuilder builder = new ConnectionConfigBuilder().withName(name).withUrl(url).withUser(user).withPassword(password).withParameters(params);
        return builder.build();
    }

    ResultCollector<CliFunctionResult, List<CliFunctionResult>> execute(CreateConnectionFunction function, ConnectionConfiguration configuration, Set<DistributedMember> targetMembers) {
        return this.executeFunction((Function)function, configuration, targetMembers);
    }

    private XmlEntity fillTabularResultData(ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector, TabularResultData tabularResultData) {
        XmlEntity xmlEntity = null;
        for (CliFunctionResult oneResult : (List)resultCollector.getResult()) {
            if (oneResult.isSuccessful()) {
                xmlEntity = this.addSuccessToResults(tabularResultData, oneResult);
                continue;
            }
            this.addErrorToResults(tabularResultData, oneResult);
        }
        return xmlEntity;
    }

    private XmlEntity addSuccessToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)oneResult.getMessage());
        return oneResult.getXmlEntity();
    }

    private void addErrorToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)(ERROR_PREFIX + oneResult.getMessage()));
        tabularResultData.setStatus(Result.Status.ERROR);
    }

    private void updateClusterConfiguration(Result result, XmlEntity xmlEntity) {
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).addXmlEntity(xmlEntity, null));
        }
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        public Result preExecution(GfshParseResult parseResult) {
            String user = parseResult.getParamValueAsString(CreateConnectionCommand.CREATE_CONNECTION__USER);
            String password = parseResult.getParamValueAsString(CreateConnectionCommand.CREATE_CONNECTION__PASSWORD);
            if (StringUtils.isNotBlank((String)password) && StringUtils.isBlank((String)user)) {
                return ResultBuilder.createUserErrorResult((String)"need to specify a user if a password is specified.");
            }
            return ResultBuilder.createInfoResult((String)"");
        }
    }
}

