/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.text.ParseException;
import java.util.Locale;
import org.apache.lucene.util.StrictStringTokenizer;

public final class Version {
    @Deprecated
    public static final Version LUCENE_5_0_0 = new Version(5, 0, 0);
    @Deprecated
    public static final Version LUCENE_5_1_0 = new Version(5, 1, 0);
    @Deprecated
    public static final Version LUCENE_5_2_0 = new Version(5, 2, 0);
    @Deprecated
    public static final Version LUCENE_5_2_1 = new Version(5, 2, 1);
    @Deprecated
    public static final Version LUCENE_5_3_0 = new Version(5, 3, 0);
    @Deprecated
    public static final Version LUCENE_5_3_1 = new Version(5, 3, 1);
    @Deprecated
    public static final Version LUCENE_5_3_2 = new Version(5, 3, 2);
    @Deprecated
    public static final Version LUCENE_5_4_0 = new Version(5, 4, 0);
    @Deprecated
    public static final Version LUCENE_5_4_1 = new Version(5, 4, 1);
    @Deprecated
    public static final Version LUCENE_5_5_0 = new Version(5, 5, 0);
    @Deprecated
    public static final Version LUCENE_5_5_1 = new Version(5, 5, 1);
    @Deprecated
    public static final Version LUCENE_5_5_2 = new Version(5, 5, 2);
    @Deprecated
    public static final Version LUCENE_5_5_3 = new Version(5, 5, 3);
    @Deprecated
    public static final Version LUCENE_5_5_4 = new Version(5, 5, 4);
    @Deprecated
    public static final Version LUCENE_6_0_0 = new Version(6, 0, 0);
    @Deprecated
    public static final Version LUCENE_6_0_1 = new Version(6, 0, 1);
    @Deprecated
    public static final Version LUCENE_6_1_0 = new Version(6, 1, 0);
    @Deprecated
    public static final Version LUCENE_6_2_0 = new Version(6, 2, 0);
    @Deprecated
    public static final Version LUCENE_6_2_1 = new Version(6, 2, 1);
    @Deprecated
    public static final Version LUCENE_6_3_0 = new Version(6, 3, 0);
    @Deprecated
    public static final Version LUCENE_6_4_0 = new Version(6, 4, 0);
    @Deprecated
    public static final Version LUCENE_6_4_1 = new Version(6, 4, 1);
    @Deprecated
    public static final Version LUCENE_6_4_2 = new Version(6, 4, 2);
    @Deprecated
    public static final Version LUCENE_6_5_0 = new Version(6, 5, 0);
    @Deprecated
    public static final Version LUCENE_6_5_1 = new Version(6, 5, 1);
    @Deprecated
    public static final Version LUCENE_6_6_0 = new Version(6, 6, 0);
    @Deprecated
    public static final Version LUCENE_6_6_1 = new Version(6, 6, 1);
    public static final Version LUCENE_6_6_2;
    public static final Version LATEST;
    @Deprecated
    public static final Version LUCENE_CURRENT;
    public final int major;
    public final int minor;
    public final int bugfix;
    public final int prerelease;
    private final int encodedValue;

    public static Version parse(String version) throws ParseException {
        int minor;
        int major;
        StrictStringTokenizer tokens = new StrictStringTokenizer(version, '.');
        if (!tokens.hasMoreTokens()) {
            throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
        }
        String token = tokens.nextToken();
        try {
            major = Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            ParseException p = new ParseException("Failed to parse major version from \"" + token + "\" (got: " + version + ")", 0);
            p.initCause(nfe);
            throw p;
        }
        if (!tokens.hasMoreTokens()) {
            throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
        }
        token = tokens.nextToken();
        try {
            minor = Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            ParseException p = new ParseException("Failed to parse minor version from \"" + token + "\" (got: " + version + ")", 0);
            p.initCause(nfe);
            throw p;
        }
        int bugfix = 0;
        int prerelease = 0;
        if (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            try {
                bugfix = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                ParseException p = new ParseException("Failed to parse bugfix version from \"" + token + "\" (got: " + version + ")", 0);
                p.initCause(nfe);
                throw p;
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                try {
                    prerelease = Integer.parseInt(token);
                }
                catch (NumberFormatException nfe) {
                    ParseException p = new ParseException("Failed to parse prerelease version from \"" + token + "\" (got: " + version + ")", 0);
                    p.initCause(nfe);
                    throw p;
                }
                if (prerelease == 0) {
                    throw new ParseException("Invalid value " + prerelease + " for prerelease; should be 1 or 2 (got: " + version + ")", 0);
                }
                if (tokens.hasMoreTokens()) {
                    throw new ParseException("Version is not in form major.minor.bugfix(.prerelease) (got: " + version + ")", 0);
                }
            }
        }
        try {
            return new Version(major, minor, bugfix, prerelease);
        }
        catch (IllegalArgumentException iae) {
            ParseException pe = new ParseException("failed to parse version string \"" + version + "\": " + iae.getMessage(), 0);
            pe.initCause(iae);
            throw pe;
        }
    }

    public static Version parseLeniently(String version) throws ParseException {
        String versionOrig = version;
        switch (version = version.toUpperCase(Locale.ROOT)) {
            case "LATEST": 
            case "LUCENE_CURRENT": {
                return LATEST;
            }
        }
        version = version.replaceFirst("^LUCENE_(\\d+)_(\\d+)_(\\d+)$", "$1.$2.$3").replaceFirst("^LUCENE_(\\d+)_(\\d+)$", "$1.$2.0").replaceFirst("^LUCENE_(\\d)(\\d)$", "$1.$2.0");
        try {
            return Version.parse(version);
        }
        catch (ParseException pe) {
            ParseException pe2 = new ParseException("failed to parse lenient version string \"" + versionOrig + "\": " + pe.getMessage(), 0);
            pe2.initCause(pe);
            throw pe2;
        }
    }

    public static Version fromBits(int major, int minor, int bugfix) {
        return new Version(major, minor, bugfix);
    }

    private Version(int major, int minor, int bugfix) {
        this(major, minor, bugfix, 0);
    }

    private Version(int major, int minor, int bugfix, int prerelease) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.prerelease = prerelease;
        if (major > 255 || major < 0) {
            throw new IllegalArgumentException("Illegal major version: " + major);
        }
        if (minor > 255 || minor < 0) {
            throw new IllegalArgumentException("Illegal minor version: " + minor);
        }
        if (bugfix > 255 || bugfix < 0) {
            throw new IllegalArgumentException("Illegal bugfix version: " + bugfix);
        }
        if (prerelease > 2 || prerelease < 0) {
            throw new IllegalArgumentException("Illegal prerelease version: " + prerelease);
        }
        if (prerelease != 0 && (minor != 0 || bugfix != 0)) {
            throw new IllegalArgumentException("Prerelease version only supported with major release (got prerelease: " + prerelease + ", minor: " + minor + ", bugfix: " + bugfix + ")");
        }
        this.encodedValue = major << 18 | minor << 10 | bugfix << 2 | prerelease;
        assert (this.encodedIsValid());
    }

    public boolean onOrAfter(Version other) {
        return this.encodedValue >= other.encodedValue;
    }

    public String toString() {
        if (this.prerelease == 0) {
            return "" + this.major + "." + this.minor + "." + this.bugfix;
        }
        return "" + this.major + "." + this.minor + "." + this.bugfix + "." + this.prerelease;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Version && ((Version)o).encodedValue == this.encodedValue;
    }

    private boolean encodedIsValid() {
        assert (this.major == (this.encodedValue >>> 18 & 0xFF));
        assert (this.minor == (this.encodedValue >>> 10 & 0xFF));
        assert (this.bugfix == (this.encodedValue >>> 2 & 0xFF));
        assert (this.prerelease == (this.encodedValue & 3));
        return true;
    }

    public int hashCode() {
        return this.encodedValue;
    }

    static {
        LUCENE_CURRENT = LATEST = (LUCENE_6_6_2 = new Version(6, 6, 2));
    }
}

